#ifndef	__FDS_H__
#define	__FDS_H__

#include	"..\interface.h"

typedef	struct	FDS
{
	PReadFunc Read;
	PWriteFunc Write;
	u8 DiskNum;
	u16 IRQcounter;
	u16_n IRQlatch;
	u8 IRQenabled;
	u8 IOenable;
	u8 IOcontrol;
	u8 IOstatus;
	u8 DriveStatus;
	int BytePtr;
	u8 WriteSkip;
	u8 DiskIRQ;
}	TFDS, *PFDS;

extern	TFDS	FDS;

int	FDS_SaveMI (Ar128 MI);
int	FDS_LoadMI (const Ar128 MI);
void	FDS_Init (void);
void	FDS_HBlank (int,int);
void	FDS_MenuClick (int,int,int,int);
void	FDS_MapperSnd (s16 *,int);
int	FDS_Read (int,int);
void	FDS_Write (int,int,int);

#endif	/* __FDS_H__ */