#ifndef	__MMC3_H__
#define	__MMC3_H__

#include	"..\interface.h"

typedef	struct	MMC3
{
	u8 IRQenabled, IRQcounter, IRQlatch;
	u8 Cmd;
	u8 PRG[2];
	u8 CHR[8];
	u8 WriteWRAM;
	u8 Mirror;
	PWriteFunc WriteFunc_WRAM;
	void	(*Sync)	(void);
}	TMMC3, *PMMC3;

extern	TMMC3	MMC3;

void	MMC3_Init (void (*)(void));
void	MMC3_SyncMirror (void);
int	MMC3_GetPRGBank (int);
int	MMC3_GetCHRBank (int);
void	MMC3_SyncPRG (int,int);
void	MMC3_SyncCHR_ROM (int,int);
void	MMC3_SyncCHR_RAM (int,int);
int	MMC3_SaveMI (Ar128);
int	MMC3_LoadMI (const Ar128);
void	MMC3_Write (int,int,int);
void	MMC3_WriteWRAM (int,int,int);
void	MMC3_HBlank (int,int);

#endif	/* __MMC3_H__ */