#include	"h_MMC4.h"

static	TMMC4	MMC4;

void	MMC4_Init (void (*Sync)(void))
{
	u8 x;
	for (x = 0; x < 2; x++)
	{
		MMC4.LatchState[x] = 0xFE;
		MMC4.Latch0[x] = 0;
		MMC4.Latch1[x] = 0;
	}
	for (x = 0xA; x < 0x10; x++)
		MP->SetWriteHandler(x,MMC4_Write);
	MMC4.Sync = Sync;
	MMC4.Sync();
}

int	MMC4_SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = MMC4.LatchState[0];
	MI[x++] = MMC4.LatchState[1];
	MI[x++] = MMC4.Latch0[0];
	MI[x++] = MMC4.Latch0[1];
	MI[x++] = MMC4.Latch1[0];
	MI[x++] = MMC4.Latch1[1];
	return x;
}

int	MMC4_LoadMI (const Ar128 MI)
{
	u8 x = 0;
	MMC4.LatchState[0]	= MI[x++];
	MMC4.LatchState[1]	= MI[x++];
	MMC4.Latch0[0]		= MI[x++];
	MMC4.Latch0[1]		= MI[x++];
	MMC4.Latch1[0]		= MI[x++];
	MMC4.Latch1[1]		= MI[x++];
	return x;
}

void	MMC4_SyncPRG (int AND, int OR)
{
	MP->SetPRG_ROM16(0x8,(MMC4.PRG & AND) | OR);
	MP->SetPRG_ROM16(0xC,(0xFF & AND) | OR);
}

void	MMC4_SyncCHR (void)
{
	if (MMC4.LatchState[0] == 0xFD)
		MP->SetCHR_ROM4(0,MMC4.Latch0[0]);
	else if (MMC4.LatchState[0] == 0xFE)
		MP->SetCHR_ROM4(0,MMC4.Latch0[1]);
	else	MP->DbgOut("WARNING: MMC4 latch 0 undefined!");

	if (MMC4.LatchState[1] == 0xFD)
		MP->SetCHR_ROM4(4,MMC4.Latch1[0]);
	else if (MMC4.LatchState[1] == 0xFE)
		MP->SetCHR_ROM4(4,MMC4.Latch1[1]);
	else	MP->DbgOut("WARNING: MMC4 latch 1 undefined!");
}

void	MMC4_SyncMirror (void)
{
	if (MMC4.Mirror & 1)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

int	MMC4_TileHandler (int Bank, int TileNum, int Index)
{
	if ((TileNum == 0xFD) || (TileNum == 0xFE))
	{
		MMC4.LatchState[Bank ? 1 : 0] = TileNum;
		MMC4_SyncCHR();
		return 1;
	}
	return 0;
}

void	MMC4_Write (int Bank, int Where, int What)
{
	switch (Bank)
	{
	case 0xA:	MMC4.PRG = What;	break;
	case 0xB:	MMC4.Latch0[0] = What;	break;
	case 0xC:	MMC4.Latch0[1] = What;	break;
	case 0xD:	MMC4.Latch1[0] = What;	break;
	case 0xE:	MMC4.Latch1[1] = What;	break;
	case 0xF:	MMC4.Mirror = What;	break;
	}
	MMC4.Sync();
}