#ifndef	__MMC5_H__
#define	__MMC5_H__

#include	"..\interface.h"

typedef	struct	MMC5
{
	int WRAMtable[4][8];
	u8 PRGsize, CHRsize, WRAMsize;
	u8 IRQenabled, IRQreads, IRQline;
	u8 Mul1, Mul2, GfxMode;
	u8 CHR_A[8], CHR_B[4];
	u8 PRG[5];
	u8 WRAMprot[2];
	u8 SplitMode;
	u8 SplitBank;
	u16_n SplitScroll;
	u8 SplitScrollT;
	u8 *NameTable0, *NameTable1, *ExRAM, *ExNameTable;
	u8 UpdateCache;
	u8 TileCache;
	u8 DrawStatus, DrawBank;
	PWriteFunc PRG_Write_6789ABCDEF;
}	TMMC5, *PMMC5;

extern	TMMC5	MMC5;

void	MMC5_Init (void);
int	MMC5_SaveMI (Ar128);
int	MMC5_LoadMI (const Ar128);
void	MMC5_SetPRG (int,int,int);
void	MMC5_SyncPRG (void);
void	MMC5_SyncCHRA (int);
void	MMC5_SyncCHRB (int);
int	MMC5_Read (int,int);
void	MMC5_Write (int,int,int);
void	MMC5_WritePRG (int,int,int);
int	MMC5_TileHandler (int,int,int);
void	MMC5_HBlank (int,int);
void	MMC5_MapperSnd (s16 *,int);

#endif	/* __MMC5_H__ */