#include "h_MMC6.h"

TMMC6	MMC6;

void MMC6_Init (void (*Sync)(void))
{
	u8 x;
	MMC6.PRG[0] = 0x00;	MMC6.PRG[1] = 0x01;	MMC6.PRG[2] = 0x3E;	MMC6.PRG[3] = 0x3F;

	MMC6.CHR[0] = 0x00;	MMC6.CHR[1] = 0x01;	MMC6.CHR[2] = 0x02;	MMC6.CHR[3] = 0x03;
	MMC6.CHR[4] = 0x04;	MMC6.CHR[5] = 0x05;	MMC6.CHR[6] = 0x06;	MMC6.CHR[7] = 0x07;

	MMC6.IRQenabled = MMC6.IRQcounter = MMC6.IRQlatch1 = MMC6.IRQlatch2 = MMC6.IRQreset = 0;
	MMC6.Cmd = 0;
	MMC6.WriteWRAM = 0;
	MMC6.Mirror = 0;

	MMC6.ReadFunc_WRAM = MP->GetReadHandler(0x6);
	MP->SetReadHandler(0x6,MMC6_ReadWRAM);
	MP->SetReadHandler(0x7,MMC6_ReadWRAM);
	MMC6.WriteFunc_WRAM = MP->GetWriteHandler(0x6);
	MP->SetWriteHandler(0x6,MMC6_WriteWRAM);
	MP->SetWriteHandler(0x7,MMC6_WriteWRAM);

	for (x = 0x8; x < 0x10; x++)
		MP->SetWriteHandler(x,MMC6_Write);
	MMC6.Sync = Sync;
	MMC6.Sync();
}

void MMC6_SyncMirror (void)
{
	if (MMC6.Mirror & 1)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

void MMC6_SyncPRG (int AND, int OR)
{
	u8 SwPRG = (MMC6.Cmd & 0x40) >> 4;

	MP->SetPRG_ROM8(SwPRG ^ 0x8,(MMC6.PRG[0] & AND) | OR);
	MP->SetPRG_ROM8(	0xA,(MMC6.PRG[1] & AND) | OR);
	MP->SetPRG_ROM8(SwPRG ^ 0xC,(MMC6.PRG[2] & AND) | OR);
	MP->SetPRG_ROM8(	0xE,(MMC6.PRG[3] & AND) | OR);
}

void MMC6_SyncCHR_ROM (int AND, int OR)
{
	u8 x, SwCHR = (MMC6.Cmd & 0x80) >> 5;

	for (x = 0; x < 8; x++)
		MP->SetCHR_ROM1(SwCHR ^ x,(MMC6.CHR[x] & AND) | OR);
}

void MMC6_SyncCHR_RAM (void)
{
	u8 x, SwCHR = (MMC6.Cmd & 0x80) >> 5;

	for (x = 0; x < 8; x++)
		MP->SetCHR_RAM1(SwCHR ^ x,MMC6.CHR[x] & 0x7);
}

int MMC6_SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			MI[x++] = MMC6.IRQcounter;
			MI[x++] = MMC6.IRQlatch2;
			MI[x++] = MMC6.IRQenabled;
			MI[x++] = MMC6.Cmd;
for (i = 0; i < 2; i++) MI[x++] = MMC6.PRG[i];
for (i = 0; i < 8; i++) MI[x++] = MMC6.CHR[i];
			MI[x++] = MMC6.WriteWRAM;
			MI[x++] = MMC6.IRQlatch1;
			MI[x++] = MMC6.IRQreset;
			MI[x++] = MMC6.Mirror;
	return x;
}

int MMC6_LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			MMC6.IRQcounter	= MI[x++];
			MMC6.IRQlatch2	= MI[x++];
			MMC6.IRQenabled	= MI[x++];
			MMC6.Cmd	= MI[x++];
for (i = 0; i < 2; i++) MMC6.PRG[i]	= MI[x++];
for (i = 0; i < 8; i++) MMC6.CHR[i]	= MI[x++];
			MMC6.WriteWRAM	= MI[x++];
			MMC6.IRQlatch1	= MI[x++];
			MMC6.IRQreset	= MI[x++];
			MMC6.Mirror	= MI[x++];
	MMC6.PRG[2] = 0x3E;	MMC6.PRG[3] = 0x3F;
	MMC6.Sync();
	return x;
}

int MMC6_ReadWRAM (int Bank, int Where)
{
	return MMC6.ReadFunc_WRAM(0x6,Where & 0x3FF);
}

void MMC6_WriteWRAM (int Bank, int Where, int What)
{
	if (MMC6.WriteWRAM)	/* only 1kb :) */
		MMC6.WriteFunc_WRAM(0x6,Where & 0x3FF,What);
}

void MMC6_Write (int Bank, int Where, int What)
{
	u16 Loc = (Bank << 12) | Where;
	switch (Loc & 0xE001)
	{
	case 0x8000:	MMC6.Cmd = What;	break;
	case 0x8001:	switch (MMC6.Cmd & 0x7)
			{
			case 0:	MMC6.CHR[0] = (What & 0xFE) | 0;
				MMC6.CHR[1] = (What & 0xFE) | 1;break;
			case 1:	MMC6.CHR[2] = (What & 0xFE) | 0;
				MMC6.CHR[3] = (What & 0xFE) | 1;break;
			case 2:	MMC6.CHR[4] = What;		break;
			case 3:	MMC6.CHR[5] = What;		break;
			case 4:	MMC6.CHR[6] = What;		break;
			case 5:	MMC6.CHR[7] = What;		break;
			case 6:	MMC6.PRG[0] = What;		break;
			case 7:	MMC6.PRG[1] = What;		break;
			}			break;
	case 0xA000:	MMC6.Mirror = What;	break;
	case 0xA001:	MMC6.WriteWRAM = What;	break;
	case 0xC000:	MMC6.IRQcounter = MMC6.IRQlatch1 = What;
			MMC6.IRQenabled = 1;	break;
	case 0xC001:	MMC6.IRQlatch2 = What;	break;
	case 0xE000:	MMC6.IRQenabled = 0;	break;
	case 0xE001:	MMC6.IRQenabled = 1;
			MMC6.IRQreset = 1;	break;
	}
	MMC6.Sync();
}

void MMC6_HBlank (int Scanline, int Byte2001)
{
	if (MMC6.IRQreset)
	{
		MMC6.IRQreset = 0;
		MMC6.IRQcounter = MMC6.IRQlatch1;
		MMC6.IRQlatch1 = MMC6.IRQlatch2;
	}

	if ((Scanline < 0) || (Scanline > 239)) return;
	if ((MMC6.IRQenabled) && ((Byte2001 & 0x18) /*== 0x18*/))
	{
		if (MMC6.IRQcounter == 0)
		{
			MMC6.IRQreset = 1;
			MMC6.IRQenabled = 0; 
			MP->IRQ();
		}
		else MMC6.IRQcounter--;
	}
}