#ifndef __MMC6_H__
#define __MMC6_H__

#include "..\interface.h"

typedef struct MMC6
{
	u8 IRQenabled, IRQcounter, IRQlatch1, IRQlatch2, IRQreset;
	u8 Cmd;
	u8 PRG[4];
	u8 CHR[8];
	u8 WriteWRAM;
	u8 Mirror;
	PReadFunc ReadFunc_WRAM;
	PWriteFunc WriteFunc_WRAM;
	void	(*Sync)	(void);
}	TMMC6, *PMMC6;

extern TMMC6 MMC6;

void MMC6_Init (void (*)(void));
void MMC6_SyncMirror (void);
void MMC6_SyncPRG (int,int);
void MMC6_SyncCHR_ROM (int,int);
void MMC6_SyncCHR_RAM (void);
int MMC6_SaveMI (Ar128);
int MMC6_LoadMI (const Ar128);
int MMC6_ReadWRAM (int,int);
void MMC6_WriteWRAM (int,int,int);
void MMC6_Write (int,int,int);
void MMC6_HBlank (int,int);

#endif		/* __MMC6_H__ */