#include	"h_VS.h"

TVS	VS;

int	VS_Read (int Bank,int Where)
{
	int What = VS.Read(Bank,Where);
	if (Where == 0x016)
	{
		What &= 0x83;
		What |= VS.Coin;
		What |= ((VS.DipSwitch & 0x03) << 3);
	}
	if (Where == 0x017)
	{
		What &= 0x03;
		What |= VS.DipSwitch & 0xFC;
	}
	return What;
}

void	VS_Init (int IsHardReset)
{
	int dip;

	VS.CoinDelay = 0;
	VS.Coin = 0;			/* always clear coins */

	if (IsHardReset)
		VS.DipSwitch = 0;	/* only clear dipswitches on hard reset */

	if (!(MP->Flags & 0x0100))
		return;

	VS.Read = MP->GetReadHandler(0x4);
	MP->SetReadHandler(0x4,VS_Read);

	MP->AddMenuItem(MP->GetMenuRoot(),"&Left coin",		0,0,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(MP->GetMenuRoot(),"&Right coin",	0,1,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(MP->GetMenuRoot(),"&Service switch",	0,2,-1,-1,MENU_NOCHECK);

	dip = MP->AddMenuItem(MP->GetMenuRoot(),"&Dip Switches",-1,-1,-1,-1,MENU_NOCHECK);

	MP->AddMenuItem(dip,"&0",1,0,-1,-1,((VS.DipSwitch >> 0) & 1) ? MENU_CHECKED : MENU_UNCHECKED);
	MP->AddMenuItem(dip,"&1",1,1,-1,-1,((VS.DipSwitch >> 1) & 1) ? MENU_CHECKED : MENU_UNCHECKED);
	MP->AddMenuItem(dip,"&2",1,2,-1,-1,((VS.DipSwitch >> 2) & 1) ? MENU_CHECKED : MENU_UNCHECKED);
	MP->AddMenuItem(dip,"&3",1,3,-1,-1,((VS.DipSwitch >> 3) & 1) ? MENU_CHECKED : MENU_UNCHECKED);
	MP->AddMenuItem(dip,"&4",1,4,-1,-1,((VS.DipSwitch >> 4) & 1) ? MENU_CHECKED : MENU_UNCHECKED);
	MP->AddMenuItem(dip,"&5",1,5,-1,-1,((VS.DipSwitch >> 5) & 1) ? MENU_CHECKED : MENU_UNCHECKED);
	MP->AddMenuItem(dip,"&6",1,6,-1,-1,((VS.DipSwitch >> 6) & 1) ? MENU_CHECKED : MENU_UNCHECKED);
	MP->AddMenuItem(dip,"&7",1,7,-1,-1,((VS.DipSwitch >> 7) & 1) ? MENU_CHECKED : MENU_UNCHECKED);
}

void	VS_MenuClick (int Command, int Parm1, int Parm2, int Parm3)
{
	switch (Command)
	{
	case 0:	switch (Parm1)
		{
		case 0:	VS.Coin |= 0x20;	break;
		case 1:	VS.Coin |= 0x40;	break;
		case 2:	VS.Coin |= 0x04;	break;
		}
		VS.CoinDelay = 15;	break;
	case 1:	VS.DipSwitch ^= (1 << Parm1);	break;
	}
}

void	VS_CheckCoin (int Scanline)
{
	if ((Scanline == 0) && (VS.CoinDelay > 0))
	{
		VS.CoinDelay--;
		if (VS.CoinDelay == 0)
			VS.Coin = 0;
	}
}