#include	"..\DLL\d_NSF.h"
#include	"..\Hardware\Sound\s_FDS.h"
#include	"..\Hardware\Sound\s_MMC5.h"
#include	"..\Hardware\Sound\s_VRC6.h"
#include	"..\Hardware\Sound\s_VRC7.h"

static	struct
{
	u8 VRC7reg;
	u8 ExRAM[1024];
	PWriteFunc Write4;
}	NSF;

static	void	PRG_Write_4_FDS (int Bank, int Where, int What)
{
	if (Where < 0x18)
		NSF.Write4(Bank,Where,What);
	FDSSoundWrite((Bank << 12) | Where,What);
}

static	void	PRG_Write_5 (int Bank,int Where,int What)
{
	if (Where & 0xFF8) MP->SetPRG_ROM4(Where & 0xF,What);
}

static	void	PRG_Write_9_VRC6 (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0:
	case 1:
	case 2:	SetVRC6Snd(0,Where,What);	break;
	}
}

static	void	PRG_Write_A_VRC6 (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0:
	case 1:
	case 2:	SetVRC6Snd(1,Where,What);	break;
	}
}

static	void	PRG_Write_B_VRC6 (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0:
	case 1:
	case 2:	SetVRC6Snd(2,Where,What);	break;
	}
}

static	void	PRG_Write_9_VRC7 (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0x010:	NSF.VRC7reg = What;			break;
	case 0x030:	VRC7_SoundWrite(NSF.VRC7reg,What);	break;
	}
}

static	int	PRG_Read_5_MMC5 (int Bank, int Where)
{
	switch (Where & 0xF00)
	{
	case 0xC00:
	case 0xD00:
	case 0xE00:
	case 0xF00:	return NSF.ExRAM[Where & 0x3FF];	break;
	}
	return MP->GetReadHandler(0x8)(Bank,Where);
}

static	void	PRG_Write_5_MMC5 (int Bank,int Where,int What)
{
	switch (Where & 0xF00)
	{
	case 0x000:
		switch (Where)
		{
		case 0x000:	SetMMC5Snd(0,0,What);	break;
		case 0x001:				break;
		case 0x002:	SetMMC5Snd(0,2,What);	break;
		case 0x003:	SetMMC5Snd(0,3,What);	break;
		case 0x004:	SetMMC5Snd(1,0,What);	break;
		case 0x005:				break;
		case 0x006:	SetMMC5Snd(1,2,What);	break;
		case 0x007:	SetMMC5Snd(1,3,What);	break;
		case 0x010:	/* PCM */		break;
		case 0x011:	/* PCM */		break;
		case 0x015:	SetMMC5Snd(3,0,What);	break;
		}		break;
	case 0xC00:
	case 0xD00:
	case 0xE00:
	case 0xF00:	if ((Where & 0xFF8) == 0xFF8)
				MP->SetPRG_ROM4(Where & 0xF,What);
			else	NSF.ExRAM[Where & 0x3FF] = What;	break;
	}
}

static	void	MapperSnd (s16 *Buffer, int Len)
{
	if (MP->Flags & 0x01)		/* VRC6 */
		GetVRC6Snd(Buffer,Len);
	else if (MP->Flags & 0x02)	/* VRC7*/
		GetVRC7Snd(Buffer,Len);
	else if (MP->Flags & 0x04)	/* FDS */
		GetFDSSnd(Buffer,Len);
	else if (MP->Flags & 0x08)	/* MMC5 */
		GetMMC5Snd(Buffer,Len);
	else if (MP->Flags & 0x10)	/* Namco 106 */;
	else if (MP->Flags & 0x20)	/* Sunsoft FME-7 */;
}

static	void	UnloadMapper (void)
{
	if (MP->Flags & 0x02)	/* VRC7 */
		KillOPL2();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	NSF.Write4 = MP->GetWriteHandler(0x4);
	MP->SetWriteHandler(0x5,PRG_Write_5);
	MP->SetReadHandler(0x5,MP->GetReadHandler(0x8));

	if (MP->Flags & 0x01)		/* VRC6 */
	{
		MP->SetWriteHandler(0x9,PRG_Write_9_VRC6);
		MP->SetWriteHandler(0xA,PRG_Write_A_VRC6);
		MP->SetWriteHandler(0xB,PRG_Write_B_VRC6);
	}
	else if (MP->Flags & 0x02)	/* VRC7 */
	{
		NSF.VRC7reg = 0;
		CreateOPL2();
		MP->SetWriteHandler(0x9,PRG_Write_9_VRC7);
	}
	else if (MP->Flags & 0x04)	/* FDS */
	{
		FDSSoundReset();
		MP->SetWriteHandler(0x4,PRG_Write_4_FDS);
	}
	else if (MP->Flags & 0x08)	/* MMC5 */
	{
		MP->SetReadHandler(0x5,PRG_Read_5_MMC5);
		MP->SetWriteHandler(0x5,PRG_Write_5_MMC5);
	}
	else if (MP->Flags & 0x10)	/* Namco 106 */;
	else if (MP->Flags & 0x20)	/* Sunsoft FME-7 */;
}

CTMapperInfo	MapperInfo_NSF =
{
	"NSF",
	666,
	MS_Full,
	4096,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	NULL,
	NULL,
	MapperSnd,
	NULL
};