#include	"..\..\DLL\d_UNIF.h"

static	struct
{
	u8 Bank, Mode;
}	Mapper;

static	void	Sync (void)
{
	MP->SetCHR_RAM8(0,0);
	switch (Mapper.Mode)
	{
	case 0:	MP->Mirror_V();
		MP->SetPRG_ROM8(0x6,Mapper.Bank | 0x2C | 3);
		MP->SetPRG_ROM8(0x8,Mapper.Bank | 0x00 | 0);
		MP->SetPRG_ROM8(0xA,Mapper.Bank | 0x00 | 1);
		MP->SetPRG_ROM8(0xC,Mapper.Bank | 0x0C | 2);
		MP->SetPRG_ROM8(0xE,Mapper.Bank | 0x0C | 3);		break;
	case 1:	MP->Mirror_V();
		MP->SetPRG_ROM8(0x6,Mapper.Bank | 0x20 | 3);
		MP->SetPRG_ROM8(0x8,Mapper.Bank | 0x00 | 0);
		MP->SetPRG_ROM8(0xA,Mapper.Bank | 0x00 | 1);
		MP->SetPRG_ROM8(0xC,Mapper.Bank | 0x00 | 2);
		MP->SetPRG_ROM8(0xE,Mapper.Bank | 0x00 | 3);		break;
	case 2:	MP->Mirror_V();
		MP->SetPRG_ROM8(0x6,Mapper.Bank | 0x2E | 3);
		MP->SetPRG_ROM8(0x8,Mapper.Bank | 0x02 | 0);
		MP->SetPRG_ROM8(0xA,Mapper.Bank | 0x02 | 1);
		MP->SetPRG_ROM8(0xC,Mapper.Bank | 0x0E | 2);
		MP->SetPRG_ROM8(0xE,Mapper.Bank | 0x0E | 3);		break;
	case 3:	MP->Mirror_H();
		MP->SetPRG_ROM8(0x6,Mapper.Bank | 0x20 | 3);
		MP->SetPRG_ROM8(0x8,Mapper.Bank | 0x00 | 0);
		MP->SetPRG_ROM8(0xA,Mapper.Bank | 0x00 | 1);
		MP->SetPRG_ROM8(0xC,Mapper.Bank | 0x00 | 2);
		MP->SetPRG_ROM8(0xE,Mapper.Bank | 0x00 | 3);		break;
	}
}

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.Bank;
	MI[x++] = Mapper.Mode;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.Bank	= MI[x++];
	Mapper.Mode	= MI[x++];
	Sync();
}

static	void	Write67 (int Bank, int Where, int What)
{
	Mapper.Mode = ((What & 0x10) >> 3) | ((What & 0x02) >> 1);
	Sync();
}

static	void	Write8F (int Bank, int Where, int What)
{
	Mapper.Bank = (What & 0xF) << 2;
	if (Bank & 0x4)
		Mapper.Mode = (Mapper.Mode & 0x1) | ((What & 0x10) >> 3);
	Sync();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	for (x = 0x6; x < 0x8; x++)
		MP->SetWriteHandler(x,Write67);
	for (x = 0x8; x <= 0xF; x++)
		MP->SetWriteHandler(x,Write8F);

	Mapper.Bank = 0;
	Mapper.Mode = 1;
	Sync();
}

CTMapperInfo	MapperInfo_BMC_1992Ballgames11in1 =
{
	"BMC_1992Ballgames11in1",
	-1,
	MS_Full,
	8192,
	InitMapper,
	NULL,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
