#include	"..\..\DLL\d_UNIF.h"

static	struct
{
	u8 Game;
        u8 CHR[8];
	u8 PRG[2];
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	for (x = 0; x < 4; x++)
                MP->SetCHR_ROM1(x,(Mapper.Game << 5) | Mapper.CHR[x]);
	
	for (x = 0; x < 2; x++)
		MP->SetPRG_ROM16(0x8 | (x << 2),(Mapper.Game << 3) | Mapper.PRG[x]);
}

static	void	Write (int Bank, int Where, int What)
{
	u16 Loc = (Bank << 12) | Where;
        switch (Loc)
	{
        case 0x6000:    Mapper.CHR[0] = What & 0x3F;    break;
        case 0x6001:    Mapper.CHR[1] = What & 0x3F;    break;
        case 0x6002:    Mapper.CHR[2] = What & 0x3F;    break;
        case 0x6003:    Mapper.CHR[3] = What & 0x3F;    break;
	case 0x6004:	/* mirroring */		break;
	case 0x7000:	Mapper.PRG[0] = What & 0x7;	break;
	case 0x7001:	Mapper.PRG[1] = What & 0x7;	break;
	}
	Sync();
}

static	void	WriteGame (int Bank, int Where, int What)
{
	Mapper.Game = What;
	Sync();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	for (x = 0x6; x < 0x8; x++)
		MP->SetWriteHandler(x,Write);
	for (x = 0x8; x < 0x10; x++)
		MP->SetWriteHandler(x,WriteGame);

	Mapper.PRG[0] = 6;	Mapper.PRG[1] = 7;
	Mapper.Game = 0;
	
	Sync();
}

const	TMapperInfo	MapperInfo_BMC_1995SuperHiK4in1 =
{
	"BMC-1995SuperHik4in1",
	-1,
	MS_None,
	32768,
	InitMapper,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};


