#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	u8 What = MP->GetReadHandler(_74xx.Addr >> 12)(_74xx.Addr >> 12,_74xx.Addr & 0xFFF);
	if (What & 0x0E)
	{
		MP->SetPRG_ROM16(0x8,0x0F);
		MP->SetPRG_ROM16(0xC,What & 0x0F);
	}
	else	MP->SetPRG_ROM32(0x8,0);
	MP->SetCHR_ROM8(0,What & 0x0F);
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
	UNIF_SetMirroring(NULL);
}

CTMapperInfo	MapperInfo_BMC_Generic15in1 =
{
	"BMC-Generic15in1",
	-1,
	MS_Full,
	16384,
	InitMapper,
	NULL,
	NULL,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	NULL
};