#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	union
	{
		struct
		{
			unsigned         : 1;
			unsigned PRG     : 4;
			unsigned PRGsize : 1;
			unsigned Mirror  : 2;
			unsigned         : 8;
		};
		struct
		{
			unsigned addr    :16;
		};
	}	Latch;
	Latch.addr = _74xx.Addr;
	
	MP->SetCHR_RAM8(0,0);
	if (Latch.PRGsize)
		MP->SetPRG_ROM32(0x8,Latch.PRG);
	else
	{
		MP->SetPRG_ROM16(0x8,Latch.PRG << 1);
		MP->SetPRG_ROM16(0x8,Latch.PRG << 1);
	}
	switch (Latch.Mirror)
	{
	case 0:	MP->Mirror_S0();		break;
	case 1:	MP->Mirror_V();			break;
	case 2:	MP->Mirror_H();			break;
	case 3:	MP->Mirror_Custom(0,1,1,1);	break;
	}
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
}

CTMapperInfo	MapperInfo_BMC_Generic20in1 =
{
	"BMC-Generic20in1",
	-1,
	MS_Full,
	16384,
	InitMapper,
	NULL,
	NULL,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	NULL
};