#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_MMC3.h"

static	struct
{
	u8 WhichGame;
	u8 DidWrite;
	PWriteFunc Write67;
}	Mapper;

static	void	Sync (void)
{
	u8 PRGmask, CHRmask;
	u8 PRGbank, CHRbank;

	if (Mapper.WhichGame & 0x8)
	{
		PRGmask = 0x0F;
		PRGbank = Mapper.WhichGame & 0x07;
	}
	else
	{
		PRGmask = 0x1F;
		PRGbank = Mapper.WhichGame & 0x06;
	}
	if (Mapper.WhichGame & 0x40)
	{
		CHRmask = 0x7F;
		CHRbank = ((Mapper.WhichGame & 0x20) >> 3) | ((Mapper.WhichGame & 0x10) >> 4) | ((Mapper.WhichGame & 0x04) >> 1);
	}
	else
	{
		CHRmask = 0xFF;
		CHRbank = ((Mapper.WhichGame & 0x20) >> 3) | ((Mapper.WhichGame & 0x10) >> 4);
	}
	MMC3_SyncMirror();
	MMC3_SyncPRG(PRGmask,PRGbank << 4);
	MMC3_SyncCHR_ROM(CHRmask,CHRbank << 7);
}

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0;
	x += MMC3_SaveMI(&MI[x]);
	MI[x++] = Mapper.WhichGame;
	MI[x++] = Mapper.DidWrite;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	x += MMC3_LoadMI(&MI[x]);
	Mapper.WhichGame	= MI[x++];
	Mapper.DidWrite		= MI[x++];
	Sync();
}

static	void	Write67 (int Bank, int Where, int What)
{
	Mapper.Write67(Bank,Where,What);
	if (Mapper.DidWrite)
		return;
	Mapper.WhichGame = What;
	Mapper.DidWrite = 1;
	Sync();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	Mapper.Write67 = MP->GetWriteHandler(0x6);
	MP->SetWriteHandler(0x6,Write67);
	MP->SetWriteHandler(0x7,Write67);

	MP->SetPRG_RAM8(0x6,0);		/* WRAM goes here */

	Mapper.WhichGame = 0;
	Mapper.DidWrite = 0;

	MMC3_Init(Sync);
}

CTMapperInfo	MapperInfo_BMC_Mario7in1 =
{
	"BMC-Mario7in1",
	-1,
	MS_Full,
	8192,
	InitMapper,
	NULL,
	MMC3_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};