#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_74xx.h"

static	struct
{
	u8 Game;
}	Mapper;

static	void	Sync (void)
{
	MP->SetCHR_ROM8(0,Mapper.Game);
	MP->SetPRG_ROM16(0x8,Mapper.Game);
	MP->SetPRG_ROM16(0xC,Mapper.Game);
}

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.Game;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.Game = MI[x++];
	Sync();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	if (IsHardReset)
		Mapper.Game = 0;
	else	Mapper.Game++;
	Sync();
	UNIF_SetMirroring(NULL);
}

CTMapperInfo	MapperInfo_BMC_Reset4in1 =
{
	"BMC-Reset4in1",
	-1,
	MS_Full,
	32768,
	InitMapper,
	NULL,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};