#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_74xx.h"

static	void	AxROM_SyncPRG_CHR (int Mask)
{
	MP->SetPRG_ROM32(0x8,_74xx.Data & Mask);
	MP->SetCHR_RAM8(0,0);
}
static	void	AxROM_SyncMirror (void)
{
	if (_74xx.Data & 0x10)
		MP->Mirror_S1();
	else	MP->Mirror_S0();
}

static	void	Sync_AMROM (void)
{
	AxROM_SyncPRG_CHR(0x3);
	AxROM_SyncMirror();
}
static	void	Sync_ANROM (void)
{
	AxROM_SyncPRG_CHR(0x3);
	AxROM_SyncMirror();
}
static	void	Sync_AOROM (void)
{
	AxROM_SyncPRG_CHR(0x7);
	AxROM_SyncMirror();
}

static	void	InitMapper_AMROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync_AMROM,IsHardReset,TRUE);
}
static	void	InitMapper_ANROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync_ANROM,IsHardReset,FALSE);
}
static	void	InitMapper_AOROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync_AOROM,IsHardReset,TRUE);
}

CTMapperInfo	MapperInfo_NES_AMROM =
{
	"NES-AMROM",
	-1,
	MS_Full,
	32768,
	InitMapper_AMROM,
	NULL,
	NULL,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_ANROM =
{
	"NES-ANROM",
	-1,
	MS_Full,
	32768,
	InitMapper_ANROM,
	NULL,
	NULL,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_AOROM =
{
	"NES-AOROM",
	-1,
	MS_Full,
	32768,
	InitMapper_AOROM,
	NULL,
	NULL,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	NULL
};