#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_MMC5.h"

static	void	InitMapper_ELROM (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;

	MP->SetReadHandler(0x5,MMC5_Read);
	MP->SetWriteHandler(0x5,MMC5_Write);
	MMC5.PRG_Write_6789ABCDEF = MP->GetWriteHandler(0x8);
	for (x = 6; x <= 0xF; x++)
		MP->SetWriteHandler(x,MMC5_WritePRG);

	MMC5.WRAMsize = 0;	/* none */
	MMC5_Init();
	MMC5_SyncPRG();
}

static	void	InitMapper_ETROM (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;

	MP->SetReadHandler(0x5,MMC5_Read);
	MP->SetWriteHandler(0x5,MMC5_Write);
	MMC5.PRG_Write_6789ABCDEF = MP->GetWriteHandler(0x8);
	for (x = 6; x <= 0xF; x++)
		MP->SetWriteHandler(x,MMC5_WritePRG);

	UNIF_InitSRAM(8192);

	MMC5.WRAMsize = 2;	/* 16kb */
	MMC5_Init();
	MMC5_SyncPRG();
}

static	void	InitMapper_EWROM (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;

	MP->SetReadHandler(0x5,MMC5_Read);
	MP->SetWriteHandler(0x5,MMC5_Write);
	MMC5.PRG_Write_6789ABCDEF = MP->GetWriteHandler(0x8);
	for (x = 6; x <= 0xF; x++)
		MP->SetWriteHandler(x,MMC5_WritePRG);

	UNIF_InitSRAM(32768);

	MMC5.WRAMsize = 3;	/* 32kb */
	MMC5_Init();
	MMC5_SyncPRG();
}

static	void	UnloadMapper (void)
{
	UNIF_SaveSRAM();
}

CTMapperInfo	MapperInfo_NES_ELROM =
{
	"NES-ELROM",
	-1,
	MS_Nearly,
	8192,
	InitMapper_ELROM,
	NULL,
	MMC5_HBlank,
	MMC5_TileHandler,
	MMC5_SaveMI,
	MMC5_LoadMI,
	MMC5_MapperSnd,
	NULL
};
CTMapperInfo	MapperInfo_NES_ETROM =
{
	"NES-ETROM",
	-1,
	MS_Nearly,
	8192,
	InitMapper_ETROM,
	UnloadMapper,
	MMC5_HBlank,
	MMC5_TileHandler,
	MMC5_SaveMI,
	MMC5_LoadMI,
	MMC5_MapperSnd,
	NULL
};
CTMapperInfo	MapperInfo_NES_EWROM =
{
	"NES-EWROM",
	-1,
	MS_Nearly,
	8192,
	InitMapper_EWROM,
	UnloadMapper,
	MMC5_HBlank,
	MMC5_TileHandler,
	MMC5_SaveMI,
	MMC5_LoadMI,
	MMC5_MapperSnd,
	NULL
};