#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_FME07.h"

static	void	Sync_JLROM (void)
{
	FME07_SyncPRG(0x3F,0);
	FME07_SyncCHR(0xFF,0);
	FME07_SyncMirror();
}

static	void	Sync_BTR (void)
{
	FME07_SyncPRG(0x3F,0);
	FME07_SyncCHR(0xFF,0);
	FME07_SyncMirror();
}

static	void	UnloadMapper (void)
{
	UNIF_SaveSRAM();
}

static	void	InitMapper_JLROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	FME07_Init(Sync_JLROM);
}
static	void	InitMapper_BTR (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	FME07_Init(Sync_BTR);
}

CTMapperInfo	MapperInfo_NES_JLROM =
{
	"NES-JLROM",
	-1,
	MS_Nearly,
	8192,
	InitMapper_JLROM,
	NULL,
	FME07_HBlank,
	NULL,
	FME07_SaveMI,
	FME07_LoadMI,
	FME07_MapperSnd,
	NULL
};
CTMapperInfo	MapperInfo_NES_BTR =
{
	"NES-BTR",
	-1,
	MS_Nearly,
	8192,
	InitMapper_BTR,
	NULL,
	FME07_HBlank,
	NULL,
	FME07_SaveMI,
	FME07_LoadMI,
	FME07_MapperSnd,
	NULL
};