#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_74xx.h"

static	void	Sync_MHROM (void)
{
	MP->SetPRG_ROM32(0x8,(_74xx.Data >> 4) & 0x1);
	MP->SetCHR_ROM8(0,(_74xx.Data >> 0) & 0x1);
}

static	void	InitMapper_MHROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync_MHROM,IsHardReset,TRUE);
	UNIF_SetMirroring(NULL);
}

CTMapperInfo	MapperInfo_NES_MHROM =
{
	"NES-MHROM",
	-1,
	MS_Full,
	32768,
	InitMapper_MHROM,
	NULL,
	NULL,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	NULL
};