#include	"..\..\DLL\d_UNIF.h"

static	void	InitMapper_NROM_128 (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,0);

	if (MP->CHR_ROM_Size)
		MP->SetCHR_ROM8(0,0);
	else	MP->SetCHR_RAM8(0,0);

	UNIF_SetMirroring(NULL);
}

static	void	InitMapper_RROM_128 (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,0);

	if (MP->CHR_ROM_Size)
		MP->SetCHR_ROM8(0,0);
	else	MP->SetCHR_RAM8(0,0);

	UNIF_SetMirroring(NULL);
}

static	void	InitMapper_NROM_256 (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MP->SetPRG_ROM32(0x8,0);

	if (MP->CHR_ROM_Size)
		MP->SetCHR_ROM8(0,0);
	else	MP->SetCHR_RAM8(0,0);

	UNIF_SetMirroring(NULL);
}

CTMapperInfo	MapperInfo_NES_NROM_128 =
{
	"NES-NROM-128",
	-1,
	MS_Full,
	32768,
	InitMapper_NROM_128,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_RROM_128 =
{
	"NES-RROM-128",
	-1,
	MS_Full,
	32768,
	InitMapper_RROM_128,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_NROM_256 =
{
	"NES-NROM-256",
	-1,
	MS_Full,
	32768,
	InitMapper_NROM_256,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};