#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_MMC1.h"

static	void	Sync_SAROM (void)
{
	MMC1_SyncMirror();
	MMC1_SyncPRG(0x7,0);
	MMC1_SyncCHR_ROM(0x0F,0);
	MMC1_SyncWRAM();
}
static	void	Sync_SBROM (void)
{
	MMC1_SyncMirror();
	MMC1_SyncPRG(0x7,0);
	MMC1_SyncCHR_ROM(0x0F,0);
}
static	void	Sync_SCROM (void)
{
	MMC1_SyncMirror();
	MMC1_SyncPRG(0x7,0);
	MMC1_SyncCHR_ROM(0x1F,0);
}
static	void	Sync_SEROM (void)
{
	MMC1_SyncMirror();
	MMC1_SyncPRG(0x1,0);
	MMC1_SyncCHR_ROM(0x0F,0);
}
static	void	Sync_SGROM (void)
{
	MMC1_SyncMirror();
	MMC1_SyncPRG(0xF,0);
	MMC1_SyncCHR_RAM(0x1,0);
}
static	void	Sync_SKROM (void)
{
	MMC1_SyncMirror();
	MMC1_SyncPRG(0xF,0);
	MMC1_SyncCHR_ROM(0x1F,0);
	MMC1_SyncWRAM();
}
static	void	Sync_SLROM (void)
{
	MMC1_SyncMirror();
	MMC1_SyncPRG(0xF,0);
	MMC1_SyncCHR_ROM(0x1F,0);
}
static	void	Sync_SL1ROM (void)
{
	MMC1_SyncMirror();
	MMC1_SyncPRG(0x7,0);
	MMC1_SyncCHR_ROM(0x1F,0);
}
static	void	Sync_SNROM (void)
{
	MMC1_SyncMirror();
	MMC1_SyncPRG(0xF,0);
	MMC1_SyncCHR_RAM(0x01,0);
	MMC1_SyncWRAM();
}
static	void	Sync_SOROM (void)
{
	MMC1_SyncMirror();
	MMC1_SyncPRG(0xF,0);
	MMC1_SyncCHR_RAM(0x01,0);
	if (MMC1_GetWRAMEnabled())
		MP->SetPRG_RAM8(0x6,((MMC1_GetCHRBankLo() & 0x10) >> 4) ^ 1);
	else
	{
		MP->SetPRG_OB4(0x6);
		MP->SetPRG_OB4(0x7);
	}
}

static	void	InitMapper_SAROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	UNIF_InitSRAM(8192);
	MMC1_Init(Sync_SAROM);
}
static	void	InitMapper_SBROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MMC1_Init(Sync_SBROM);
}
static	void	InitMapper_SCROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MMC1_Init(Sync_SCROM);
}
static	void	InitMapper_SEROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MMC1_Init(Sync_SEROM);
}
static	void	InitMapper_SGROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MMC1_Init(Sync_SGROM);
}
static	void	InitMapper_SKROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	UNIF_InitSRAM(8192);
	MMC1_Init(Sync_SKROM);
}
static	void	InitMapper_SLROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MMC1_Init(Sync_SLROM);
}
static	void	InitMapper_SL1ROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MMC1_Init(Sync_SL1ROM);
}

static	void	InitMapper_SNROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	UNIF_InitSRAM(8192);
	MMC1_Init(Sync_SNROM);
}
static	void	InitMapper_SOROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	UNIF_InitSRAM(8192);
	MMC1_Init(Sync_SOROM);
}

static	void	UnloadMapper (void)
{
	UNIF_SaveSRAM();
}

CTMapperInfo	MapperInfo_NES_SAROM =
{
	"NES-SAROM",
	-1,
	MS_Full,
	16384,
	InitMapper_SAROM,
	UnloadMapper,
	NULL,
	NULL,
	MMC1_SaveMI,
	MMC1_LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_SBROM =
{
	"NES-SBROM",
	-1,
	MS_Full,
	16384,
	InitMapper_SBROM,
	NULL,
	NULL,
	NULL,
	MMC1_SaveMI,
	MMC1_LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_SCROM =
{
	"NES-SCROM",
	-1,
	MS_Full,
	16384,
	InitMapper_SCROM,
	NULL,
	NULL,
	NULL,
	MMC1_SaveMI,
	MMC1_LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_SEROM =
{
	"NES-SEROM",
	-1,
	MS_Full,
	16384,
	InitMapper_SEROM,
	NULL,
	NULL,
	NULL,
	MMC1_SaveMI,
	MMC1_LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_SGROM =
{
	"NES-SGROM",
	-1,
	MS_Full,
	16384,
	InitMapper_SGROM,
	NULL,
	NULL,
	NULL,
	MMC1_SaveMI,
	MMC1_LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_SKROM =
{
	"NES-SKROM",
	-1,
	MS_Full,
	16384,
	InitMapper_SKROM,
	UnloadMapper,
	NULL,
	NULL,
	MMC1_SaveMI,
	MMC1_LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_SLROM =
{
	"NES-SLROM",
	-1,
	MS_Full,
	16384,
	InitMapper_SLROM,
	NULL,
	NULL,
	NULL,
	MMC1_SaveMI,
	MMC1_LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_SL1ROM =
{
	"NES-SL1ROM",
	-1,
	MS_Full,
	16384,
	InitMapper_SL1ROM,
	NULL,
	NULL,
	NULL,
	MMC1_SaveMI,
	MMC1_LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_SNROM =
{
	"NES-SNROM",
	-1,
	MS_Full,
	16384,
	InitMapper_SNROM,
	UnloadMapper,
	NULL,
	NULL,
	MMC1_SaveMI,
	MMC1_LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_SOROM =
{
	"NES-SOROM",
	-1,
	MS_Full,
	16384,
	InitMapper_SOROM,
	UnloadMapper,
	NULL,
	NULL,
	MMC1_SaveMI,
	MMC1_LoadMI,
	NULL,
	NULL
};