#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_74xx.h"

static	void	Sync_UNROM (void)
{
	MP->SetPRG_ROM16(0x8,_74xx.Data & 0x7);
	MP->SetPRG_ROM16(0xC,0x7);
	MP->SetCHR_RAM8(0,0);
}
static	void	Sync_UOROM (void)
{
	MP->SetPRG_ROM16(0x8,_74xx.Data & 0xF);
	MP->SetPRG_ROM16(0xC,0xF);
	MP->SetCHR_RAM8(0,0);
}

static	void	InitMapper_UNROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync_UNROM,IsHardReset,TRUE);
	UNIF_SetMirroring(NULL);
}

static	void	InitMapper_UOROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync_UOROM,IsHardReset,TRUE);
	UNIF_SetMirroring(NULL);
}

CTMapperInfo	MapperInfo_NES_UNROM =
{
	"NES-UNROM",
	-1,
	MS_Full,
	16384,
	InitMapper_UNROM,
	NULL,
	NULL,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_UOROM =
{
	"NES-UOROM",
	-1,
	MS_Full,
	16384,
	InitMapper_UOROM,
	NULL,
	NULL,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	NULL
};