#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_VS.h"

static	void	HBlank (int Scanline,int Byte2001)
{
	VS_CheckCoin(Scanline);
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,1);

	if (MP->CHR_ROM_Size)
		MP->SetCHR_ROM8(0,0);
	else	MP->SetCHR_RAM8(0,0);

	iNES_InitROM();
	VS_Init(IsHardReset);		/* check for VS unisystem */
}

CTMapperInfo	MapperInfo_000 =
{
	"NROM",
	0,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	NULL,
	NULL,
	NULL,
	VS_MenuClick
};