#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC1.h"
#include	"..\Hardware\h_VS.h"

static	void	Sync (void)
{
	MMC1_SyncMirror();
	if (MP->PRG_ROM_Size > 262144)
	{
		MP->SetPRG_ROM16(0x8,MMC1_GetPRGBankLo() & 0xF | (MMC1_GetCHRBankLo() & 0x10));
		MP->SetPRG_ROM16(0xC,MMC1_GetPRGBankHi() & 0xF | (MMC1_GetCHRBankLo() & 0x10));
	}
	else	MMC1_SyncPRG(0xF,0);
	if (MP->CHR_ROM_Size)
		MMC1_SyncCHR_ROM(0x1F,0);
	else	MMC1_SyncCHR_RAM(0x01,0);
	MMC1_SyncWRAM();
}

static	void	HBlank (int Scanline,int Byte2001)
{
	VS_CheckCoin(Scanline);
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();
	MMC1_Init(Sync);
	VS_Init(IsHardReset);		/* check for VS unisystem */
}

CTMapperInfo	MapperInfo_001 =
{
	"S*ROM (MMC1)",
	1,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	MMC1_SaveMI,
	MMC1_LoadMI,
	NULL,
	VS_MenuClick
};