#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_VS.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	MP->SetPRG_ROM16(0x8,_74xx.Data & 0xF);
	MP->SetPRG_ROM16(0xC,-1);
	MP->SetCHR_RAM8(0,0);
}

static	void	HBlank (int Scanline,int Byte2001)
{
	VS_CheckCoin(Scanline);
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
	iNES_InitROM();
	VS_Init(IsHardReset);		/* check for VS unisystem */
}

CTMapperInfo	MapperInfo_002 =
{
	"U*ROM",
	2,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	VS_MenuClick
};