#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC3.h"
#include	"..\Hardware\h_VS.h"

static	void	Sync (void)
{
	if (MP->Flags & 0x08)
		MP->Mirror_4();
	else	MMC3_SyncMirror();
	MMC3_SyncPRG(0x3F,0);

	if (MP->CHR_ROM_Size)
		MMC3_SyncCHR_ROM(0xFF,0);
	else	MMC3_SyncCHR_RAM(0x07,0);
}

static	void	HBlank (int Scanline,int Byte2001)
{
	VS_CheckCoin(Scanline);
	MMC3_HBlank(Scanline,Byte2001);
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	MP->SetPRG_RAM8(0x6,0);		/* WRAM goes here */

	iNES_InitROM();
	MMC3_Init(Sync);
	VS_Init(IsHardReset);		/* check for VS unisystem */
}

CTMapperInfo	MapperInfo_004 =
{
	"T*ROM/HKROM (MMC3/MMC6)",
	4,
	MS_Nearly,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	MMC3_SaveMI,
	MMC3_LoadMI,
	NULL,
	VS_MenuClick
};
