#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC5.h"
#include	"..\Hardware\Sound\s_MMC5.h"

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	MP->SetReadHandler(0x5,MMC5_Read);
	MP->SetWriteHandler(0x5,MMC5_Write);

	MMC5.PRG_Write_6789ABCDEF = MP->GetWriteHandler(0x8);

	for (x = 6; x <= 0xF; x++)
		MP->SetWriteHandler(x,MMC5_WritePRG);

	iNES_InitROM();

	MMC5.WRAMsize = 2;	/* 16kb, good enough for iNES */

	MMC5_Init();
	MMC5_SyncPRG();
}

CTMapperInfo	MapperInfo_005  =
{
	"E*ROM (MMC5)",
	5,
	MS_Nearly,
	8192,
	InitMapper,
	UnloadMapper,
	MMC5_HBlank,
	MMC5_TileHandler,
	MMC5_SaveMI,
	MMC5_LoadMI,
	MMC5_MapperSnd,
	NULL
};