#include	"..\DLL\d_iNES.h"

static	struct
{
	PWriteFunc Write4;
	u8 IRQenabled;
	u16_n IRQcounter;
}	Mapper;

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.IRQcounter.b0;
	MI[x++] = Mapper.IRQcounter.b1;
	MI[x++] = Mapper.IRQenabled;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.IRQcounter.b0	= MI[x++];
	Mapper.IRQcounter.b1	= MI[x++];
	Mapper.IRQenabled	= MI[x++];
}

static	void	HBlank (int Scanline,int Byte2001)
{
	if ((Mapper.IRQenabled) && (Mapper.IRQcounter.s0))
	{
		if (Mapper.IRQcounter.s0 > (0xFFFF - 114))
			MP->IRQ();
		else	Mapper.IRQcounter.s0 += 114;
	}
}

static	void	Write4 (int Bank, int Where, int What)
{
	if (Where < 0x018)
	{
		Mapper.Write4(Bank,Where,What);
		return;
	}
	switch (Where)
	{
	case 0x2FC:
	case 0x2FD:
	case 0x3FE:
	case 0x500:	/* ? */				break;
	case 0x2FE:	if (What & 0x10)
				MP->Mirror_S1();
			else	MP->Mirror_S0();	break;
	case 0x2FF:	if (What & 0x10)
				MP->Mirror_H();
			else	MP->Mirror_V();	break;
	case 0x501:	Mapper.IRQenabled = 0;	break;
	case 0x502:	Mapper.IRQcounter.b0 = What;
							break;
	case 0x503:	Mapper.IRQcounter.b1 = What;
			Mapper.IRQenabled = 1;	break;
	}
}

static	void	Write (int Bank, int Where, int What)
{
	MP->SetPRG_ROM16(0x8,(What & 0x3C) >> 2);
	MP->SetCHR_RAM8(0,What & 0x3);
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	Mapper.Write4 = MP->GetWriteHandler(0x4);
	MP->SetWriteHandler(0x4,Write4);

	for (x = 0x8; x <= 0xF; x++)
		MP->SetWriteHandler(x,Write);

	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,7);

	MP->SetCHR_RAM8(0,0);

	iNES_InitROM();

	Mapper.IRQenabled = 0;
	Mapper.IRQcounter.s0 = 0;
}

CTMapperInfo	MapperInfo_006 =
{
	"FFE F4xxx",
	6,
	MS_Partial,
	16384,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};