#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	MP->SetPRG_ROM32(0x8,_74xx.Data & 0x07);
	MP->SetCHR_RAM8(0,0);
	if (_74xx.Data & 0x10)
		MP->Mirror_S1();
	else	MP->Mirror_S0();
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();
	_74xx_Init(Sync,IsHardReset,FALSE);
}

CTMapperInfo	MapperInfo_007 =
{
	"A*ROM",
	7,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	NULL
};
