#include	"..\DLL\d_iNES.h"

static	void	Write (int Bank, int Where, int What)
{
	MP->SetPRG_ROM16(0x8,(What & 0xF8) >> 3);
	MP->SetCHR_ROM8(0,What & 0x7);
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;

	for (x = 0x8; x <= 0xF; x++)
		MP->SetWriteHandler(x,Write);

	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,1);
	MP->SetCHR_ROM8(0,0);

	iNES_InitROM();
}

CTMapperInfo	MapperInfo_008 =
{
	"FFE F3xxx",
	8,
	MS_Nearly,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};
