#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC4.h"

static	void	Sync (void)
{
	MMC4_SyncPRG(0xFF,0);
	MMC4_SyncCHR();
	MMC4_SyncMirror();
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();
	MMC4_Init(Sync);
}

CTMapperInfo	MapperInfo_010 =
{
	"Nintendo MMC4",
	10,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	MMC4_TileHandler,
	MMC4_SaveMI,
	MMC4_LoadMI,
	NULL,
	NULL
};