#include	"..\DLL\d_iNES.h"

static	void	Write (int Bank, int Where, int What)
{
	u8 PRGbank = (What & 0x3F) << 1;
	switch (Where)
	{
	case 0x000:
		if (What & 0x80)
		{
			MP->SetPRG_ROM8(0x8,PRGbank + 1);
			MP->SetPRG_ROM8(0xA,PRGbank + 0);
			MP->SetPRG_ROM8(0xC,PRGbank + 3);
			MP->SetPRG_ROM8(0xE,PRGbank + 2);
		}
		else
		{
			MP->SetPRG_ROM8(0x8,PRGbank + 0);
			MP->SetPRG_ROM8(0xA,PRGbank + 1);
			MP->SetPRG_ROM8(0xC,PRGbank + 2);
			MP->SetPRG_ROM8(0xE,PRGbank + 3);
		}
		if (What & 0x40) MP->Mirror_H();
		else MP->Mirror_V();
		break;
	case 0x001:	/* uncertain */
		if (What & 0x80)
		{
			MP->SetPRG_ROM8(0x8,PRGbank + 1);
			MP->SetPRG_ROM8(0xA,PRGbank + 0);
		}
		else
		{
			MP->SetPRG_ROM8(0x8,PRGbank + 0);
			MP->SetPRG_ROM8(0xA,PRGbank + 1);
		}
		break;
	case 0x002:
		if (What & 0x80)
		{
			MP->SetPRG_ROM8(0x8,PRGbank + 1);
			MP->SetPRG_ROM8(0xA,PRGbank + 1);
			MP->SetPRG_ROM8(0xC,PRGbank + 1);
			MP->SetPRG_ROM8(0xE,PRGbank + 1);
		}
		else
		{
			MP->SetPRG_ROM8(0x8,PRGbank + 0);
			MP->SetPRG_ROM8(0xA,PRGbank + 0);
			MP->SetPRG_ROM8(0xC,PRGbank + 0);
			MP->SetPRG_ROM8(0xE,PRGbank + 0);
		}
		break;
	case 0x003:
		if (What & 0x80)
		{
			MP->SetPRG_ROM8(0xC,PRGbank + 1);
			MP->SetPRG_ROM8(0xE,PRGbank + 0);
		}
		else
		{
			MP->SetPRG_ROM8(0xC,PRGbank + 0);
			MP->SetPRG_ROM8(0xE,PRGbank + 1);
		}
		if (What & 0x40) MP->Mirror_H();
		else MP->Mirror_V();
		break;
	}
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MP->SetWriteHandler(0x8,Write);
	MP->SetPRG_ROM32(0x8,0);
	if (MP->CHR_ROM_Size)	
		MP->SetCHR_ROM8(0,0);
	else	MP->SetCHR_RAM8(0,0);
	iNES_InitROM();
}

CTMapperInfo	MapperInfo_015 =
{
	"100-in-1 Contra Function 16",
	15,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};