#include	"..\DLL\d_iNES.h"

static	struct
{
	PWriteFunc Write4;
	u8 IRQenabled;
	u16_n IRQcounter;
}	Mapper;

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.IRQcounter.b0;
	MI[x++] = Mapper.IRQcounter.b1;
	MI[x++] = Mapper.IRQenabled;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.IRQcounter.b0	= MI[x++];
	Mapper.IRQcounter.b1	= MI[x++];
	Mapper.IRQenabled	= MI[x++];
}

static	void	HBlank	(int Scanline, int Byte2001)
{
	if ((Mapper.IRQenabled) && (Mapper.IRQcounter.s0))
	{
		if (Mapper.IRQcounter.s0 > (0xFFFF - 114))
			MP->IRQ();
		else	Mapper.IRQcounter.s0 += 114;
	}
	return;
}

static	void	Write (int Bank, int Where, int What)
{
	if (Where < 0x018)
	{
		Mapper.Write4(Bank,Where,What);
		return;
	}
	switch (Where)
	{
	case 0x2FE:	if (What & 0x10)
					MP->Mirror_S1();
			else	MP->Mirror_S0();	break;
	case 0x2FF:	if (What & 0x10)
				MP->Mirror_H();
			else	MP->Mirror_V();		break;
	case 0x501:	Mapper.IRQenabled = 0;		break;
	case 0x502:	Mapper.IRQcounter.b0 = What;	break;
	case 0x503:	Mapper.IRQcounter.b1 = What;
			Mapper.IRQenabled = 1;		break;
	case 0x504:	MP->SetPRG_ROM8(0x8,What);	break;
	case 0x505:	MP->SetPRG_ROM8(0xA,What);	break;
	case 0x506:	MP->SetPRG_ROM8(0xC,What);	break;
	case 0x507:	MP->SetPRG_ROM8(0xE,What);	break;
	case 0x510:	MP->SetCHR_ROM1(0,What);	break;
	case 0x511:	MP->SetCHR_ROM1(1,What);	break;
	case 0x512:	MP->SetCHR_ROM1(2,What);	break;
	case 0x513:	MP->SetCHR_ROM1(3,What);	break;
	case 0x514:	MP->SetCHR_ROM1(4,What);	break;
	case 0x515:	MP->SetCHR_ROM1(5,What);	break;
	case 0x516:	MP->SetCHR_ROM1(6,What);	break;
	case 0x517:	MP->SetCHR_ROM1(7,What);	break;
	}
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	Mapper.Write4 = MP->GetWriteHandler(0x4);
	MP->SetWriteHandler(0x4,Write);

	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,-1);

	MP->SetCHR_ROM8(0,0);

	iNES_InitROM();
	Mapper.IRQenabled = 0;
	Mapper.IRQcounter.s0 = 0;
}

CTMapperInfo	MapperInfo_017 =
{
	"FFE F8xxx",
	17,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
