#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 PRG[4], CHR[8], NTab[4];
	u8 IRQenabled;
	u16_n IRQcounter;
}	Mapper;


static	void	Sync (void)
{
	u8 x;
	for (x = 0; x < 4; x++)
		MP->SetPRG_ROM8(8 | (x << 1),Mapper.PRG[x]);
	for (x = 0; x < 8; x++)
		MP->SetCHR_ROM1(x,Mapper.CHR[x]);
}

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			MI[x++] = Mapper.IRQcounter.b0;
			MI[x++] = Mapper.IRQcounter.b1;
			MI[x++] = Mapper.IRQenabled;
for (i = 0; i < 4; i++)	MI[x++] = Mapper.PRG[i];
for (i = 0; i < 8; i++)	MI[x++] = Mapper.CHR[i];
for (i = 0; i < 4; i++)	MI[x++] = Mapper.NTab[i];
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			Mapper.IRQcounter.b0	= MI[x++];
			Mapper.IRQcounter.b1	= MI[x++];
			Mapper.IRQenabled	= MI[x++];
for (i = 0; i < 4; i++)	Mapper.PRG[i]		= MI[x++];
for (i = 0; i < 8; i++)	Mapper.CHR[i]		= MI[x++];
for (i = 0; i < 4; i++)	Mapper.NTab[i]		= MI[x++];
}

static	void	HBlank (int Scanline,int Byte2001)
{
	Mapper.IRQcounter.s0 += 114;
	if ((Mapper.IRQenabled) & (Mapper.IRQcounter.s0 >= 0x7FFF))
		MP->IRQ();
	Mapper.IRQcounter.s0 &= 0x7FFF;
}

static	int	ReadIRQ (int Bank, int Where)
{
	u8 result = 0xFF;
	switch (Where & 0x800)
	{
	case 0x000:	result = Mapper.IRQcounter.b0;	break;
	case 0x800:	result = Mapper.IRQcounter.b1;	break;
	}
	return result;
}

static	void	WriteIRQ (int Bank, int Where, int What)
{
	switch (Where & 0x800)
	{
	case 0x000:	Mapper.IRQcounter.b0 = What;		break;
	case 0x800:	Mapper.IRQcounter.b1 = What & 0x7F;
			Mapper.IRQenabled = What & 0x80;	break;
	}
}

static	void	Write (int Bank, int Where, int What)
{

	u16 Loc = (Bank << 12) | Where;
	switch (Loc & 0xF800)
	{
	case 0x8000:	Mapper.CHR[0] = What;	break;
	case 0x8800:	Mapper.CHR[1] = What;	break;
	case 0x9000:	Mapper.CHR[2] = What;	break;
	case 0x9800:	Mapper.CHR[3] = What;	break;
	case 0xA000:	Mapper.CHR[4] = What;	break;
	case 0xA800:	Mapper.CHR[5] = What;	break;
	case 0xB000:	Mapper.CHR[6] = What;	break;
	case 0xB800:	Mapper.CHR[7] = What;	break;
	case 0xC000:	Mapper.NTab[0] = What;	break;
	case 0xC800:	Mapper.NTab[1] = What;	break;
	case 0xD000:	Mapper.NTab[2] = What;	break;
	case 0xD800:	Mapper.NTab[3] = What;	break;
	case 0xE000:	Mapper.PRG[0] = What;	break;
	case 0xE800:	Mapper.PRG[1] = What;	break;
	case 0xF000:	Mapper.PRG[2] = What;	break;
	case 0xF800:	/* Mapper sound? */	break;
	}
	Sync();
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;

	MP->SetReadHandler(0x5,ReadIRQ);
	MP->SetWriteHandler(0x5,WriteIRQ);

	for (x = 0x8; x < 0x10; x++)
		MP->SetWriteHandler(x,Write);

	for (x = 0; x < 4; x++)
	{
		Mapper.PRG[x] = 0xFF;
		Mapper.CHR[x | 0] = 0xFF;
		Mapper.CHR[x | 4] = 0xFF;
		Mapper.NTab[x] = 0xFF;
	}
	Mapper.IRQenabled = 0;
	Mapper.IRQcounter.s0 = 0;

	iNES_InitROM();
	Sync();
}

CTMapperInfo	MapperInfo_019 =
{
	"Namcot 106",
	19,
	MS_Nearly,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};