#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 IRQenabled, IRQcounter;
	u8_n IRQlatch;
	u8 Byte9002;
	u8_n CHR[8];
}	Mapper;

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			MI[x++] = Mapper.IRQcounter;
			MI[x++] = Mapper.IRQenabled;
			MI[x++] = Mapper.Byte9002;
for (i = 0; i < 8; i++)	MI[x++] = Mapper.CHR[i].b0;
			MI[x++] = Mapper.IRQlatch.b0;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			Mapper.IRQcounter	= MI[x++];
			Mapper.IRQenabled	= MI[x++];
			Mapper.Byte9002		= MI[x++];
for (i = 0; i < 8; i++)	Mapper.CHR[i].b0	= MI[x++];
			Mapper.IRQlatch.b0	= MI[x++];
}

static	void	HBlank (int Scanline,int Byte2001)
{
	if (Mapper.IRQenabled & 2)
	{
		if (Mapper.IRQcounter == 0xFF)
		{
			Mapper.IRQcounter = Mapper.IRQlatch.b0;
			MP->IRQ();
		}
		else	Mapper.IRQcounter++;
	}
}

static	void	SyncCHR (void)
{
	u8 x;
	for (x = 0; x < 8; x++)
		MP->SetCHR_ROM1(x,Mapper.CHR[x].b0);
}

static	void	PRG_Write_8 (int Bank, int Where, int What)
{
	if (Where == 0)
	{
		if (Mapper.Byte9002 & 2)
			MP->SetPRG_ROM8(0xC,What);
		else	MP->SetPRG_ROM8(0x8,What);
	}
}

static	void	PRG_Write_9 (int Bank, int Where, int What)
{
	if (Where == 0)
	{
		switch (What & 3)
		{
		case 0:	MP->Mirror_V();		break;
		case 1:	MP->Mirror_H();		break;
		case 2:	MP->Mirror_S1();	break;
		case 3:	MP->Mirror_S0();	break;
		}
	}
	else if (Where == 2)
		Mapper.Byte9002 = What;
}

static	void	PRG_Write_A (int Bank, int Where, int What)
{
	if (Where == 0)
		MP->SetPRG_ROM8(0xA,What);
}

static	void	PRG_Write_B (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0x000:	Mapper.CHR[0].n0 = What & 0xF;	break;
	case 0x002:	Mapper.CHR[0].n1 = What & 0xF;	break;
	case 0x001:
	case 0x004:	Mapper.CHR[1].n0 = What & 0xF;	break;
	case 0x003:
	case 0x006:	Mapper.CHR[1].n1 = What & 0xF;	break;
	}
	SyncCHR();
}

static	void	PRG_Write_C (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0x000:	Mapper.CHR[2].n0 = What & 0xF;	break;
	case 0x002:	Mapper.CHR[2].n1 = What & 0xF;	break;
	case 0x001:
	case 0x004:	Mapper.CHR[3].n0 = What & 0xF;	break;
	case 0x003:
	case 0x006:	Mapper.CHR[3].n1 = What & 0xF;	break;
	}
	SyncCHR();
}

static	void	PRG_Write_D (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0x000:	Mapper.CHR[4].n0 = What & 0xF;	break;
	case 0x002:	Mapper.CHR[4].n1 = What & 0xF;	break;
	case 0x001:
	case 0x004:	Mapper.CHR[5].n0 = What & 0xF;	break;
	case 0x003:
	case 0x006:	Mapper.CHR[5].n1 = What & 0xF;	break;
	}
	SyncCHR();
}

static	void	PRG_Write_E (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0x000:	Mapper.CHR[6].n0 = What & 0xF;	break;
	case 0x002:	Mapper.CHR[6].n1 = What & 0xF;	break;
	case 0x001:
	case 0x004:	Mapper.CHR[7].n0 = What & 0xF;	break;
	case 0x003:
	case 0x006:	Mapper.CHR[7].n1 = What & 0xF;	break;
	}
	SyncCHR();
}

static	void	PRG_Write_F (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0x000:	Mapper.IRQlatch.n0 = What & 0xF;		break;
	case 0x002:	Mapper.IRQlatch.n1 = What & 0xF;		break;
	case 0x003:	if (Mapper.IRQenabled & 1)
				Mapper.IRQenabled |= 2;
			else	Mapper.IRQenabled &= 1;			break;
	case 0x004:	Mapper.IRQenabled = What & 3;
			if (Mapper.IRQenabled & 2)
				Mapper.IRQcounter = Mapper.IRQlatch.b0;	break;
	}
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	MP->SetWriteHandler(0x8,PRG_Write_8);
	MP->SetWriteHandler(0x9,PRG_Write_9);
	MP->SetWriteHandler(0xA,PRG_Write_A);
	MP->SetWriteHandler(0xB,PRG_Write_B);
	MP->SetWriteHandler(0xC,PRG_Write_C);
	MP->SetWriteHandler(0xD,PRG_Write_D);
	MP->SetWriteHandler(0xE,PRG_Write_E);
	MP->SetWriteHandler(0xF,PRG_Write_F);

	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,-1);

	MP->SetCHR_ROM8(0,0);

	iNES_InitROM();

	Mapper.IRQenabled = Mapper.IRQcounter = Mapper.IRQlatch.b0 = 0;
	Mapper.Byte9002 = 0;
	for (x = 0; x < 8; x++)
		Mapper.CHR[x].b0 = x;
}

CTMapperInfo	MapperInfo_021 =
{
	"Konami VRC4",
	21,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
