#include	"..\DLL\d_iNES.h"

static	void	PRG_Write_8 (int Bank, int Where, int What)
{
	MP->SetPRG_ROM8(0x8,What);
}

static	void	PRG_Write_9 (int Bank, int Where, int What)
{
	switch (What & 3)
	{
	case 0:	MP->Mirror_V();		break;
	case 1:	MP->Mirror_H();		break;
	case 2:	MP->Mirror_S1();	break;
	case 3:	MP->Mirror_S0();	break;
	}
}

static	void	PRG_Write_A (int Bank, int Where, int What)
{
	MP->SetPRG_ROM8(0xA,What);
}

static	void	PRG_Write_B (int Bank, int Where, int What)
{
	if (Where == 0)
		MP->SetCHR_ROM1(0,What >> 1);
	else if (Where == 1)
		MP->SetCHR_ROM1(1,What >> 1);
}

static	void	PRG_Write_C (int Bank, int Where, int What)
{
	if (Where == 0)
		MP->SetCHR_ROM1(2,What >> 1);
	else if (Where == 1)
		MP->SetCHR_ROM1(3,What >> 1);
}

static	void	PRG_Write_D (int Bank, int Where, int What)
{
	if (Where == 0)
		MP->SetCHR_ROM1(4,What >> 1);
	else if (Where == 1)
		MP->SetCHR_ROM1(5,What >> 1);
}

static	void	PRG_Write_E (int Bank, int Where, int What)
{
	if (Where == 0)
		MP->SetCHR_ROM1(6,What >> 1);
	else if (Where == 1)
		MP->SetCHR_ROM1(7,What >> 1);
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	MP->SetWriteHandler(0x8,PRG_Write_8);
	MP->SetWriteHandler(0x9,PRG_Write_9);
	MP->SetWriteHandler(0xA,PRG_Write_A);
	MP->SetWriteHandler(0xB,PRG_Write_B);
	MP->SetWriteHandler(0xC,PRG_Write_C);
	MP->SetWriteHandler(0xD,PRG_Write_D);
	MP->SetWriteHandler(0xE,PRG_Write_E);

	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,-1);

	MP->SetCHR_ROM8(0,0);

	iNES_InitROM();
}

CTMapperInfo	MapperInfo_022 =
{
	"Konami VRC2 Type A",
	22,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};