#include	"..\DLL\d_iNES.h"

static	struct
{
	u8_n CHR[8];
}	Mapper;

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
for (i = 0; i < 8; i++)	MI[x++] = Mapper.CHR[i].b0;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
for (i = 0; i < 8; i++)	Mapper.CHR[i].b0	= MI[x++];
}

static	void	SyncCHR (void)
{
	u8 x;
	for (x = 0; x < 8; x++)
		MP->SetCHR_ROM1(x,Mapper.CHR[x].b0);
}

static	void	PRG_Write_8 (int Bank, int Where, int What)
{
	MP->SetPRG_ROM8(0x8,What);
}

static	void	PRG_Write_9 (int Bank, int Where, int What)
{
	switch (What & 3)
	{
	case 0:	MP->Mirror_V();		break;
	case 1:	MP->Mirror_H();		break;
	case 2:	MP->Mirror_S1();	break;
	case 3:	MP->Mirror_S0();	break;
	}
}

static	void	PRG_Write_A (int Bank, int Where, int What)
{
	What &= 0xF;
	MP->SetPRG_ROM8(0xA,What);
}

static	void	PRG_Write_B (int Bank, int Where, int What)
{
	What &= 0xF;
	switch (Where & 3)
	{
	case 0:	Mapper.CHR[0].n0 = What;	break;
	case 1:	Mapper.CHR[0].n1 = What;	break;
	case 2:	Mapper.CHR[1].n0 = What;	break;
	case 3:	Mapper.CHR[1].n1 = What;	break;
	}
	SyncCHR();
}

static	void	PRG_Write_C (int Bank, int Where, int What)
{
	What &= 0xF;
	switch (Where & 3)
	{
	case 0:	Mapper.CHR[2].n0 = What;	break;
	case 1:	Mapper.CHR[2].n1 = What;	break;
	case 2:	Mapper.CHR[3].n0 = What;	break;
	case 3:	Mapper.CHR[3].n1 = What;	break;
	}
	SyncCHR();
}

static	void	PRG_Write_D (int Bank, int Where, int What)
{
	What &= 0xF;
	switch (Where & 3)
	{
	case 0:	Mapper.CHR[4].n0 = What;	break;
	case 1:	Mapper.CHR[4].n1 = What;	break;
	case 2:	Mapper.CHR[5].n0 = What;	break;
	case 3:	Mapper.CHR[5].n1 = What;	break;
	}
	SyncCHR();
}

static	void	PRG_Write_E (int Bank, int Where, int What)
{
	What &= 0xF;
	switch (Where & 3)
	{
	case 0:	Mapper.CHR[6].n0 = What;	break;
	case 1:	Mapper.CHR[6].n1 = What;	break;
	case 2:	Mapper.CHR[7].n0 = What;	break;
	case 3:	Mapper.CHR[7].n1 = What;	break;
	}
	SyncCHR();
}

static	void	PRG_Write_F (int Bank, int Where, int What)
{
	MP->DbgOut("Mapper 23: IRQ write (syntax unknown)");
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	MP->SetWriteHandler(0x8,PRG_Write_8);
	MP->SetWriteHandler(0x9,PRG_Write_9);
	MP->SetWriteHandler(0xA,PRG_Write_A);
	MP->SetWriteHandler(0xB,PRG_Write_B);
	MP->SetWriteHandler(0xC,PRG_Write_C);
	MP->SetWriteHandler(0xD,PRG_Write_D);
	MP->SetWriteHandler(0xE,PRG_Write_E);
	MP->SetWriteHandler(0xF,PRG_Write_F);

	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,-1);

	MP->SetCHR_ROM8(0,0);

	iNES_InitROM();
	for (x = 0; x < 8; x++)
		Mapper.CHR[x].b0 = x;
}

CTMapperInfo	MapperInfo_023 =
{
	"Konami VRC2 Type B",
	23,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};