#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\Sound\s_VRC6.h"

static	struct
{
	u8 IRQenabled, IRQcounter, IRQlatch;
	u8 SwapAddr[4];
	u8 PRG[2], CHR[8];
	u8 Mirror;
}	Mapper;

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			MI[x++] = Mapper.IRQcounter;
			MI[x++] = Mapper.IRQlatch;
			MI[x++] = Mapper.IRQenabled;
for (i = 0; i < 2; i++)	MI[x++] = Mapper.PRG[i];
for (i = 0; i < 8; i++)	MI[x++] = Mapper.CHR[i];
			MI[x++] = Mapper.Mirror;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			Mapper.IRQcounter	= MI[x++];
			Mapper.IRQlatch		= MI[x++];
			Mapper.IRQenabled	= MI[x++];
for (i = 0; i < 2; i++)	Mapper.PRG[i]		= MI[x++];
for (i = 0; i < 8; i++)	Mapper.CHR[i]		= MI[x++];
			Mapper.Mirror		= MI[x++];

}

static	void	HBlank (int Scanline,int Byte2001)
{
	if ((Mapper.IRQenabled & 2) && (Mapper.IRQcounter))
	{
		if (Mapper.IRQcounter == 0xFF)
		{
			Mapper.IRQcounter = Mapper.IRQlatch;
			MP->IRQ();
		}
		else	Mapper.IRQcounter++;
	}
}

static	void	Sync (void)
{
	u8 x;
	MP->SetPRG_ROM16(0x8,Mapper.PRG[0]);
	MP->SetPRG_ROM8(0xC,Mapper.PRG[1]);
	MP->SetPRG_ROM8(0xE,-1);
	for (x = 0; x < 8; x++)
		MP->SetCHR_ROM1(x,Mapper.CHR[x]);
	switch ((Mapper.Mirror >> 2) & 3)
	{
	case 0:	MP->Mirror_V();		break;
	case 1:	MP->Mirror_H();		break;
	case 2:	MP->Mirror_S0();	break;
	case 3:	MP->Mirror_S1();	break;
	}
}

static	void	Write (int Bank, int Where, int What)
{
	u16 Loc = (Bank << 12) | Mapper.SwapAddr[Where & 3] | (Where & ~3);
	switch (Loc & 0xF003)
	{
	case 0x8000:	Mapper.PRG[0] = What;	break;
	case 0x8001:				break;
	case 0x8002:				break;
	case 0x8003:				break;
	case 0x9000:	SetVRC6Snd(0,0,What);	break;
	case 0x9001:	SetVRC6Snd(0,1,What);	break;
	case 0x9002:	SetVRC6Snd(0,2,What);	break;
	case 0x9003:				break;
	case 0xA000:	SetVRC6Snd(1,0,What);	break;
	case 0xA001:	SetVRC6Snd(1,1,What);	break;
	case 0xA002:	SetVRC6Snd(1,2,What);	break;
	case 0xA003:				break;
	case 0xB000:	SetVRC6Snd(2,0,What);	break;
	case 0xB001:	SetVRC6Snd(2,1,What);	break;
	case 0xB002:	SetVRC6Snd(2,2,What);	break;
	case 0xB003:	Mapper.Mirror = What;	break;
	case 0xC000:	Mapper.PRG[1] = What;	break;
	case 0xC001:				break;
	case 0xC002:				break;
	case 0xC003:				break;
	case 0xD000:	Mapper.CHR[0] = What;	break;
	case 0xD001:	Mapper.CHR[1] = What;	break;
	case 0xD002:	Mapper.CHR[2] = What;	break;
	case 0xD003:	Mapper.CHR[3] = What;	break;
	case 0xE000:	Mapper.CHR[4] = What;	break;
	case 0xE001:	Mapper.CHR[5] = What;	break;
	case 0xE002:	Mapper.CHR[6] = What;	break;
	case 0xE003:	Mapper.CHR[7] = What;	break;
	case 0xF000:	Mapper.IRQlatch = What;	break;
	case 0xF001:	Mapper.IRQenabled = What & 3;
			if (Mapper.IRQenabled & 2)
				Mapper.IRQcounter = Mapper.IRQlatch;
						break;
	case 0xF002:	if (Mapper.IRQenabled & 1)
				Mapper.IRQenabled |= 2;
			else	Mapper.IRQenabled &= 1;
						break;
	case 0xF003:				break;
	}
	Sync();
}

static	void	MapperSnd (s16 *Buffer, int Len)
{
	GetVRC6Snd(Buffer,Len);
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	VRC6_InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;

	for (x = 0x8; x < 0x10; x++)
		MP->SetWriteHandler(x,Write);

	Mapper.PRG[0] = 0;
	Mapper.PRG[1] = -2;
	for (x = 0; x < 8; x++)	Mapper.CHR[x] = x;
	Mapper.IRQenabled = Mapper.IRQcounter = Mapper.IRQlatch = 0;

	VRC6sound_init();
	Sync();
}

static	void	InitMapper_024 (const PMapperParam _MP, int IsHardReset)
{
	VRC6_InitMapper(_MP,IsHardReset);
	Mapper.SwapAddr[0] = 0;
	Mapper.SwapAddr[1] = 1;
	Mapper.SwapAddr[2] = 2;
	Mapper.SwapAddr[3] = 3;
}

static	void	InitMapper_026 (const PMapperParam _MP, int IsHardReset)
{
	VRC6_InitMapper(_MP,IsHardReset);
	Mapper.SwapAddr[0] = 0;
	Mapper.SwapAddr[1] = 2;
	Mapper.SwapAddr[2] = 1;
	Mapper.SwapAddr[3] = 3;
}

CTMapperInfo	MapperInfo_024 =
{
	"Konami VRC6 A0/A1",
	24,
	MS_Full,
	8192,
	InitMapper_024,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	MapperSnd,
	NULL
};

CTMapperInfo	MapperInfo_026 =
{
	"Konami VRC6 A1/A0",
	26,
	MS_Full,
	8192,
	InitMapper_026,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	MapperSnd,
	NULL
};
