#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 Byte9xxx;
}	Mapper;

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.Byte9xxx;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.Byte9xxx = MI[x++];
}

static	void	PRG_Write_8 (int Bank, int Where, int What)
{
	if (Mapper.Byte9xxx & 2)
		MP->SetPRG_ROM8(0xC,What);
	else	MP->SetPRG_ROM8(0x8,What);
}

static	void	PRG_Write_9 (int Bank, int Where, int What)
{
	Mapper.Byte9xxx = What;
	if (What & 1)	MP->Mirror_H();
	else		MP->Mirror_V();
}

static	void	PRG_Write_A (int Bank, int Where, int What)
{
	MP->SetPRG_ROM8(0xA,What);
}

static	void	PRG_Write_B (int Bank, int Where, int What)
{
	switch (Where & 7)
	{
	case 0:	MP->SetCHR_ROM1(0,What);	break;
	case 1:	MP->SetCHR_ROM1(1,What);	break;
	case 2:	MP->SetCHR_ROM1(2,What);	break;
	case 3:	MP->SetCHR_ROM1(3,What);	break;
	case 4:	MP->SetCHR_ROM1(4,What);	break;
	case 5:	MP->SetCHR_ROM1(5,What);	break;
	case 6:	MP->SetCHR_ROM1(6,What);	break;
	case 7:	MP->SetCHR_ROM1(7,What);	break;
	}
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	MP->SetWriteHandler(0x8,PRG_Write_8);
	MP->SetWriteHandler(0x9,PRG_Write_9);
	MP->SetWriteHandler(0xA,PRG_Write_A);
	MP->SetWriteHandler(0xB,PRG_Write_B);

	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,-1);

	MP->SetCHR_ROM8(0,0);

	iNES_InitROM();

	Mapper.Byte9xxx = 0;
}

CTMapperInfo	MapperInfo_032 =
{
	"Irem G-101",
	32,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
