#include	"..\DLL\d_iNES.h"

static	void	PRG_Write_8 (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0:	MP->SetPRG_ROM8(0x8,What);	break;
	case 1:	MP->SetPRG_ROM8(0xA,What);	break;
	case 2:	MP->SetCHR_ROM2(0,What);	break;
	case 3:	MP->SetCHR_ROM2(2,What);	break;
	default:
		MP->DbgOut("Mapper 33 unknown write to $8xxx");
						break;
	}
}

static	void	PRG_Write_A (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0:	MP->SetCHR_ROM1(4,What);	break;
	case 1:	MP->SetCHR_ROM1(5,What);	break;
	case 2:	MP->SetCHR_ROM1(6,What);	break;
	case 3:	MP->SetCHR_ROM1(7,What);	break;
	default:
		MP->DbgOut("Mapper 33 unknown write to $Axxx");
						break;
	}
}

static	void	PRG_Write_C (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0:	if (What)
			MP->Mirror_H();
		else	MP->Mirror_V();		break;
	}
}

static	void	PRG_Write_E (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0:	if (What)
			MP->Mirror_H();
		else	MP->Mirror_V();		break;
	}
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	MP->SetWriteHandler(0x8,PRG_Write_8);
//	MP->SetWriteHandler(0x9,PRG_Write_89);
	MP->SetWriteHandler(0xA,PRG_Write_A);
//	MP->SetWriteHandler(0xB,PRG_Write_AB);
	MP->SetWriteHandler(0xC,PRG_Write_C);
//	MP->SetWriteHandler(0xD,PRG_Write_CD);
	MP->SetWriteHandler(0xE,PRG_Write_E);
//	MP->SetWriteHandler(0xF,PRG_Write_EF);


	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,-1);

	MP->SetCHR_ROM8(0,0);

	iNES_InitROM();
}

CTMapperInfo	MapperInfo_033 =
{
	"Taito TC0190",
	33,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};
