#include	"..\DLL\d_iNES.h"

static	void	PRG_Write_7 (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0xFFD:	MP->SetPRG_ROM32(0x8,What);	break;
	case 0xFFE:	MP->SetCHR_ROM4(0,What);	break;
	case 0xFFF:	MP->SetCHR_ROM4(4,What);	break;
	}
}

static	void	PRG_Write_89ABCDEF (int Bank, int Where, int What)
{
	MP->SetPRG_ROM32(0x8,What);
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	MP->SetWriteHandler(0x7,PRG_Write_7);

	for (x = 0x8; x <= 0xF; x++)
		MP->SetWriteHandler(x,PRG_Write_89ABCDEF);

	MP->SetPRG_RAM8(0x6,0);	/* Need this for Nina-01 */
	MP->SetPRG_ROM32(0x8,0);

	if (MP->CHR_ROM_Size) MP->SetCHR_ROM8(0,0);
	else MP->SetCHR_RAM8(0,0);

	iNES_InitROM();
}

CTMapperInfo	MapperInfo_034 =
{
	"BNROM/Nina-01",
	34,
	MS_Nearly,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};
