#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 IRQenabled;
	u16_n IRQcounter;
	u8 PRG;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM8(0x6,6);
	MP->SetPRG_ROM8(0x8,4);
	MP->SetPRG_ROM8(0xA,5);
	MP->SetPRG_ROM8(0xC,Mapper.PRG);
	MP->SetPRG_ROM8(0xE,7);
	MP->SetCHR_ROM8(0,0);
}

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.IRQenabled;
	MI[x++] = Mapper.IRQcounter.b0;
	MI[x++] = Mapper.IRQcounter.b1;
	MI[x++] = Mapper.PRG;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.IRQenabled	= MI[x++];
	Mapper.IRQcounter.b0	= MI[x++];
	Mapper.IRQcounter.b1	= MI[x++];
	Mapper.PRG		= MI[x++];
	Sync();
}

static	void	HBlank (int Scanline, int Byte2001)
{
	if (Mapper.IRQenabled)
	{
		Mapper.IRQcounter.s0 += 114;
		if (Mapper.IRQcounter.s0 >= 4096)
		{
			Mapper.IRQcounter.s0 -= 4096;
			MP->IRQ();
		}
	}
}

static	void	Write (int Bank, int Where, int What)
{
	u16 Loc = (Bank << 12) | Where;
	switch (Loc & 0xE000)
	{
	case 0x8000:	Mapper.IRQenabled = 0;
			Mapper.IRQcounter.s0 = 0;	break;
	case 0xA000:	Mapper.IRQenabled = 1;		break;
	case 0xC000:					break;
	case 0xE000:	Mapper.PRG = What & 7;		break;
	}
	Sync();
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	for (x = 0x8; x < 0x10; x++)
		MP->SetWriteHandler(x,Write);

	Mapper.IRQenabled = 0;
	Mapper.IRQcounter.s0 = 0;
	Mapper.PRG = 0;

	iNES_InitROM();
	Sync();
}

CTMapperInfo	MapperInfo_040 =
{
	"SMB2j Pirate",
	40,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};