#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 IRQenabled;
	u16_n IRQcounter;
	u8 PRG;
	u8 Mirror;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM8(0x6,Mapper.PRG);
	MP->SetPRG_ROM32(0x8,3);
	if (Mapper.Mirror)
		MP->Mirror_H();
	else	MP->Mirror_V();
	MP->SetCHR_RAM8(0,0);
}

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.IRQenabled;
	MI[x++] = Mapper.IRQcounter.b0;
	MI[x++] = Mapper.IRQcounter.b1;
	MI[x++] = Mapper.PRG;
	MI[x++] = Mapper.Mirror;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.IRQenabled	= MI[x++];
	Mapper.IRQcounter.b0	= MI[x++];
	Mapper.IRQcounter.b1	= MI[x++];
	Mapper.PRG		= MI[x++];
	Mapper.Mirror		= MI[x++];
	Sync();
}

static	void	HBlank (int Scanline, int Byte2001)
{
	if (Mapper.IRQenabled)
	{
		Mapper.IRQcounter.s0 += 114;
		if (Mapper.IRQcounter.s0 >= 24576)
			MP->IRQ();
	}
}

static	void	Write (int Bank, int Where, int What)
{
	switch (Where & 0x3)
	{
	case 0:	Mapper.PRG = What & 0x0F;	break;
	case 1:	Mapper.Mirror = What & 0x8;	break;
	case 2:	if (What & 0x02)
			Mapper.IRQenabled = 1;
		else
		{
			Mapper.IRQenabled = 0;
			Mapper.IRQcounter.s0 = 0;
		}				break;
	case 3:					break;
	}
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	for (x = 0xE; x < 0x10; x++)
		MP->SetWriteHandler(x,Write);

	Mapper.PRG = Mapper.Mirror = 0;

	Mapper.IRQenabled = 0;
	Mapper.IRQcounter.s0 = 0;

	iNES_InitROM();
	Sync();
}

CTMapperInfo	MapperInfo_042 =
{
	"Mario Baby",
	42,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};