#include	"..\DLL\d_iNES.h"

static	struct
{
	PWriteFunc Write4;
	u8 IRQenabled;
	u16_n IRQcounter;
	u8 PRG;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM4(0x5,(8 << 1) | 1);
	MP->SetPRG_ROM8(0x6,2);
	MP->SetPRG_ROM8(0x8,1);
	MP->SetPRG_ROM8(0xA,0);
	MP->SetPRG_ROM8(0xC,Mapper.PRG);
	MP->SetPRG_ROM8(0xE,9);
	MP->SetCHR_ROM8(0,0);
}

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.IRQenabled;
	MI[x++] = Mapper.IRQcounter.b0;
	MI[x++] = Mapper.IRQcounter.b1;
	MI[x++] = Mapper.PRG;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.IRQenabled	= MI[x++];
	Mapper.IRQcounter.b0	= MI[x++];
	Mapper.IRQcounter.b1	= MI[x++];
	Mapper.PRG		= MI[x++];
	Sync();
}

static	void	HBlank (int Scanline, int Byte2001)
{
	if (Mapper.IRQenabled)
	{
		Mapper.IRQcounter.s0 += 114;
		if (Mapper.IRQcounter.s0 >= 4096)
		{
			Mapper.IRQcounter.s0 -= 4096;
			MP->IRQ();
		}
	}
}

static	void	Write (int Bank, int Where, int What)
{
	const u8 PRGbanks[8] = {4,3,4,4,4,7,5,6};
	u16 Loc = (Bank << 12) | Where;
	if (Bank == 4)
		Mapper.Write4(Bank,Where,What);
	if ((Loc & 0x1FF) == 0x4022)
	{
		Mapper.PRG = PRGbanks[What & 7];
		Sync();
	}
	if ((Loc & 0x1FF) == 0x122)
	{
		if (What & 3)
			Mapper.IRQenabled = 1;
		else
		{
			Mapper.IRQcounter.s0 = 0;
			Mapper.IRQenabled = 0;
		}
	}
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	Mapper.Write4 = MP->GetWriteHandler(0x4);

	MP->SetReadHandler(0x5,MP->GetReadHandler(0x8));

	for (x = 0x4; x < 0x10; x++)
		MP->SetWriteHandler(x,Write);

	iNES_InitROM();

	Mapper.PRG = 0;
	Mapper.IRQenabled = 1;
	Mapper.IRQcounter.s0 = 0;
	Sync();
}

CTMapperInfo	MapperInfo_043 =
{
	"SMB2j (LF36)",
	43,
	MS_Full,
	4096,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
