#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 GameBanks, CurBanks;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM32(0x8,((Mapper.GameBanks & 0x0F) << 1) | (Mapper.CurBanks & 0x01));
	MP->SetCHR_ROM8(0,((Mapper.GameBanks & 0xF0) >> 1) | ((Mapper.CurBanks & 0x70) >> 4));
}

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.GameBanks;
	MI[x++] = Mapper.CurBanks;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.GameBanks	= MI[x++];
	Mapper.CurBanks		= MI[x++];
	Sync();
}

static	void	WriteLo (int Bank, int Where, int What)
{
	Mapper.GameBanks = What;
	Sync();
}

static	void	WriteHi (int Bank, int Where, int What)
{
	Mapper.CurBanks = What;
	Sync();
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	for (x = 0x6; x < 0x8; x++)
		MP->SetWriteHandler(x,WriteLo);
	for (x = 0x8; x < 0x10; x++)
		MP->SetWriteHandler(x,WriteHi);

	Mapper.GameBanks = Mapper.CurBanks = 0;

	Sync();

	iNES_InitROM();
}

CTMapperInfo	MapperInfo_046 =
{
	"GameStation/RumbleStation",
	46,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
