#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC3.h"

static	struct
{
	u8 Reg;
}	Mapper;

static	void	Sync (void)
{
	MMC3_SyncMirror();
	MMC3_SyncPRG(0xF,Mapper.Reg << 4);
	MMC3_SyncCHR_ROM(0x7F,Mapper.Reg << 7);
}

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0;
	x += MMC3_SaveMI(&MI[x]);
	MI[x++] = Mapper.Reg;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	x += MMC3_LoadMI(&MI[x]);
	Mapper.Reg	= MI[x++];
	Sync();
}

static	void	PRG_Write_67 (int Bank, int Where, int What)
{
	Mapper.Reg = What & 1;
	Sync();
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	MP->SetWriteHandler(0x6,PRG_Write_67);
	MP->SetWriteHandler(0x7,PRG_Write_67);

	iNES_InitROM();
	Mapper.Reg = 0;
	MMC3_Init(Sync);
}

CTMapperInfo	MapperInfo_047 =
{
	"Super Spike & Nintendo World Cup Soccer (MMC3)",
	47,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	MMC3_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};