#include	"..\DLL\d_iNES.h"

static	struct
{
	PWriteFunc Write4;
	u8 IRQenabled;
	u16_n IRQcounter;
	u8 PRG;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM8(0x6,0xF);
	MP->SetPRG_ROM8(0x8,0x8);
	MP->SetPRG_ROM8(0xA,0x9);
	MP->SetPRG_ROM8(0xC,((Mapper.PRG & 0x1) << 2) | ((Mapper.PRG & 0x6) >> 1) | (Mapper.PRG & 0x8));
	MP->SetPRG_ROM8(0xE,0xB);
	MP->SetCHR_RAM8(0,0);
}

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.IRQenabled;
	MI[x++] = Mapper.IRQcounter.b0;
	MI[x++] = Mapper.IRQcounter.b1;
	MI[x++] = Mapper.PRG;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.IRQenabled	= MI[x++];
	Mapper.IRQcounter.b0	= MI[x++];
	Mapper.IRQcounter.b1	= MI[x++];
	Mapper.PRG		= MI[x++];
	Sync();
}

static	void	HBlank (int Scanline, int Byte2001)
{
	if (Mapper.IRQenabled)
	{
		Mapper.IRQcounter.s0 += 114;
		if (Mapper.IRQcounter.s0 >= 4096)
		{
			Mapper.IRQcounter.s0 -= 4096;
			MP->IRQ();
		}
	}
}

static	void	Write (int Bank, int Where, int What)
{
	if (Bank == 4)
		Mapper.Write4(Bank,Where,What);
	if ((Where & 0x060) != 0x020)
		return;
	if (Where & 0x100)
	{
		if (What & 1)
			Mapper.IRQenabled = 1;
		else
		{
			Mapper.IRQcounter.s0 = 0;
			Mapper.IRQenabled = 0;
		}
	}
	else
	{
		Mapper.PRG = What;
		Sync();
	}
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;

	Mapper.Write4 = MP->GetWriteHandler(0x4);
	for (x = 0x4; x < 0x6; x++)
		MP->SetWriteHandler(x,Write);
	Mapper.PRG = 0;
	Mapper.IRQenabled = 0;
	Mapper.IRQcounter.s0 = 0;

	iNES_InitROM();
	Sync();
}

CTMapperInfo	MapperInfo_050 =
{
	"SMB2j rev. A",
	50,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
