#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	union
	{
		struct
		{
			unsigned PRG     : 4;
			unsigned PRGsize : 1;
			unsigned PRG16   : 1;
			unsigned         : 1;
			unsigned Mir_HV  : 1;
			unsigned         : 8;
		};
		struct
		{
			unsigned n       :16;
		};
	}	Addr;
	Addr.n = _74xx.Addr;
	MP->SetCHR_RAM8(0,0);
	if (Addr.PRGsize)
	{
		MP->SetPRG_ROM16(0x8,(Addr.PRG << 1) | Addr.PRG16);
		MP->SetPRG_ROM16(0xC,(Addr.PRG << 1) | Addr.PRG16);
	}
	else	MP->SetPRG_ROM32(0x8,Addr.PRG);
	if (Addr.Mir_HV)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
}

CTMapperInfo	MapperInfo_061 =
{
	"20-in-1",
	61,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	NULL
};