#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 IRQenabled, IRQcounter, IRQlatch;
	u8 Cmd;
	u8 PRG[3];
	u8 CHR[10];
	u8 Mirror;
}	Mapper;

static	void	Sync (void)
{
	u8 x, SwCHR = (Mapper.Cmd & 0x80) >> 5;
	if (Mapper.Mirror & 0x1)
		MP->Mirror_V();
	else	MP->Mirror_H();

	if (Mapper.Cmd & 0x40)
	{
		MP->SetPRG_ROM8(0x8,Mapper.PRG[2]);
		MP->SetPRG_ROM8(0xA,Mapper.PRG[0]);
		MP->SetPRG_ROM8(0xC,Mapper.PRG[1]);
	}
	else
	{
		MP->SetPRG_ROM8(0x8,Mapper.PRG[0]);
		MP->SetPRG_ROM8(0xA,Mapper.PRG[1]);
		MP->SetPRG_ROM8(0xC,Mapper.PRG[2]);
	}
	MP->SetPRG_ROM8(0xE,-1);

	for (x = 0; x < 8; x++)
		MP->SetCHR_ROM1(SwCHR ^ x,Mapper.CHR[x]);
	MP->SetCHR_ROM1(1,Mapper.CHR[9]);
	MP->SetCHR_ROM1(3,Mapper.CHR[10]);
}

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			MI[x++] = Mapper.IRQcounter;
			MI[x++] = Mapper.IRQlatch;
			MI[x++] = Mapper.IRQenabled;
			MI[x++] = Mapper.Cmd;
for (i = 0; i < 3; i++) MI[x++] = Mapper.PRG[i];
for (i = 0; i < 10; i++)MI[x++] = Mapper.CHR[i];
			MI[x++] = Mapper.Mirror;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			Mapper.IRQcounter	= MI[x++];
			Mapper.IRQlatch		= MI[x++];
			Mapper.IRQenabled	= MI[x++];
			Mapper.Cmd		= MI[x++];
for (i = 0; i < 3; i++) Mapper.PRG[i]		= MI[x++];
for (i = 0; i < 10; i++)Mapper.CHR[i]		= MI[x++];
			Mapper.Mirror		= MI[x++];
	Sync();
}

static	void	PRG_Write_89ABCDEF (int Bank, int Where, int What)
{
	u16 Loc = (Bank << 12) | Where;
	switch (Loc & 0xE001)
	{
	case 0x8000:	Mapper.Cmd = What;	break;
	case 0x8001:	switch (Mapper.Cmd & 0xF)
			{
			case 0:	Mapper.CHR[0] = (What & 0xFE) | 0;
				Mapper.CHR[1] = (What & 0xFE) | 1;	break;
			case 1:	Mapper.CHR[2] = (What & 0xFE) | 0;
				Mapper.CHR[3] = (What & 0xFE) | 1;	break;
			case 2:	Mapper.CHR[4] = What;			break;
			case 3:	Mapper.CHR[5] = What;			break;
			case 4:	Mapper.CHR[6] = What;			break;
			case 5:	Mapper.CHR[7] = What;			break;
			case 6:	Mapper.PRG[0] = What;			break;
			case 7:	Mapper.PRG[1] = What;			break;
			case 8:	Mapper.CHR[9] = What;			break;
			case 9:	Mapper.CHR[10] = What;			break;
			case 15:Mapper.PRG[2] = What;			break;
			}			break;
	case 0xA000:	Mapper.Mirror = What;	break;
	case 0xA001:				break;
	case 0xC000:	Mapper.IRQcounter = What;
						break;
	case 0xC001:	Mapper.IRQlatch = What;	break;
	case 0xE000:	Mapper.IRQenabled = 0;
			Mapper.IRQcounter = Mapper.IRQlatch;
						break;
	case 0xE001:	Mapper.IRQenabled = 1;	break;
	}
	Sync();
}

static	void	HBlank (int Scanline, int Byte2001)
{
	if ((Scanline < 0) || (Scanline > 239)) return;
	if ((Mapper.IRQenabled) && ((Byte2001 & 0x18) /*== 0x18*/))
	{
		if (Mapper.IRQcounter == 0)
		{
			Mapper.IRQcounter = Mapper.IRQlatch;
			MP->IRQ();
		}
		else	Mapper.IRQcounter--;
	}
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;

	for (x = 0x8; x < 0x10; x++)
		MP->SetWriteHandler(x,PRG_Write_89ABCDEF);

	iNES_InitROM();

	for (x = 0; x < 3; x++)	Mapper.PRG[x] = 0xFF;
	for (x = 0; x < 10; x++)Mapper.CHR[x] = x;

	Mapper.IRQenabled = Mapper.IRQcounter = Mapper.IRQlatch = 0;
	Mapper.Cmd = 0;
	Mapper.Mirror = 0;
	Sync();
}

CTMapperInfo	MapperInfo_064 =
{
	"Tengen RAMBO-1",
	64,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
