#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 IRQenabled, IRQcounter;
}	Mapper;

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.IRQenabled;
	MI[x++] = Mapper.IRQcounter;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.IRQenabled	= MI[x++];
	Mapper.IRQcounter	= MI[x++];
}

static void HBlank (int Scanline, int Byte2001)
{
	if (Mapper.IRQenabled)
	{
		if (Mapper.IRQcounter == 0)
		{
			Mapper.IRQenabled = 0;
			MP->IRQ();
		}
		else	Mapper.IRQcounter--;
	}
}

static	void	PRG_Write_8 (int Bank, int Where, int What)
{
	if (Where == 0)
		MP->SetPRG_ROM8(0x8,What);
}

static	void	PRG_Write_9 (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 1:	if (What & 0x80)
			MP->Mirror_V();
		else	MP->Mirror_H();				break;		
	case 5:	Mapper.IRQcounter = What << 1;		break;
	case 6:	Mapper.IRQenabled = Mapper.IRQcounter;	break;
	}
}

static	void	PRG_Write_A (int Bank, int Where, int What)
{
	if (Where == 0)
		MP->SetPRG_ROM8(0xA,What);
}

static	void	PRG_Write_B (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0:	MP->SetCHR_ROM1(0,What);	break;
	case 1:	MP->SetCHR_ROM1(1,What);	break;
	case 2:	MP->SetCHR_ROM1(2,What);	break;
	case 3:	MP->SetCHR_ROM1(3,What);	break;
	case 4:	MP->SetCHR_ROM1(4,What);	break;
	case 5:	MP->SetCHR_ROM1(5,What);	break;
	case 6:	MP->SetCHR_ROM1(6,What);	break;
	case 7:	MP->SetCHR_ROM1(7,What);	break;
	}
}

static	void	PRG_Write_C (int Bank, int Where, int What)
{
	if (Where == 0)
		MP->SetPRG_ROM8(0xC,What);
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	MP->SetWriteHandler(0x8,PRG_Write_8);
	MP->SetWriteHandler(0x9,PRG_Write_9);
	MP->SetWriteHandler(0xA,PRG_Write_A);
	MP->SetWriteHandler(0xB,PRG_Write_B);
	MP->SetWriteHandler(0xC,PRG_Write_C);

	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,-1);

	MP->SetCHR_ROM8(0,0);

	iNES_InitROM();

	Mapper.IRQcounter = Mapper.IRQenabled = 0;
}

CTMapperInfo	MapperInfo_065 =
{
	"Irem H-3001",
	65,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};