#include	"..\DLL\d_iNES.h"

static	struct
{
	u16_n IRQcounter;
	u8 IRQenabled;
	u8 IRQpos;
}	Mapper;

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.IRQcounter.b0;
	MI[x++] = Mapper.IRQcounter.b1;
	MI[x++] = Mapper.IRQenabled;
	MI[x++] = Mapper.IRQpos;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.IRQcounter.b0	= MI[x++];
	Mapper.IRQcounter.b1	= MI[x++];
	Mapper.IRQenabled	= MI[x++];
	Mapper.IRQpos		= MI[x++];
}

static	void	HBlank (int Scanline, int Byte2001)
{
	if (Mapper.IRQenabled)
	{
		if (Mapper.IRQcounter.s0 < 114)
		{
			Mapper.IRQenabled = 0;
			Mapper.IRQcounter.s0 = 0xFFFF;
			MP->IRQ();
		}
		else	Mapper.IRQcounter.s0 -= 114;
	}
}

static	void	PRG_Write_89AB (int Bank, int Where, int What)
{
	if (!(Where & 0x800))
		return;
	switch (Bank)
	{
	case 0x8:	MP->SetCHR_ROM2(0x0,What);	break;
	case 0x9:	MP->SetCHR_ROM2(0x2,What);	break;
	case 0xA:	MP->SetCHR_ROM2(0x4,What);	break;
	case 0xB:	MP->SetCHR_ROM2(0x6,What);	break;
	}
}

static	void	PRG_Write_C (int Bank, int Where, int What)
{
	if(Mapper.IRQpos)
		Mapper.IRQcounter.b0 = What;
	else	Mapper.IRQcounter.b1 = What;
	Mapper.IRQpos ^= 1;
}


static	void	PRG_Write_D (int Bank, int Where, int What)
{
	if (!(Where & 0x800))
		return;
	Mapper.IRQpos = 0;
	Mapper.IRQenabled = (What & 0x10) >> 4;
}

static	void	PRG_Write_E (int Bank, int Where, int What)
{
	if (!(Where & 0x800))
		return;
	switch (What & 3)
	{
	case 0:	MP->Mirror_V();		break;
	case 1:	MP->Mirror_H();		break;
	case 2:	MP->Mirror_S0();	break;
	case 3:	MP->Mirror_S1();	break;
	}
}

static	void	PRG_Write_F (int Bank, int Where, int What)
{
	if (!(Where & 0x800))
		return;
	MP->SetPRG_ROM16(0x8,What);
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	MP->SetWriteHandler(0x8,PRG_Write_89AB);
	MP->SetWriteHandler(0x9,PRG_Write_89AB);
	MP->SetWriteHandler(0xA,PRG_Write_89AB);
	MP->SetWriteHandler(0xB,PRG_Write_89AB);
	MP->SetWriteHandler(0xC,PRG_Write_C);
	MP->SetWriteHandler(0xD,PRG_Write_D);
	MP->SetWriteHandler(0xE,PRG_Write_E);
	MP->SetWriteHandler(0xF,PRG_Write_F);

	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,-1);
	MP->SetCHR_ROM8(0,0);

	iNES_InitROM();

	Mapper.IRQcounter.s0 = 0;
	Mapper.IRQenabled = Mapper.IRQpos = 0;

}

CTMapperInfo	MapperInfo_067 =
{
	"Sunsoft Mapper #3",
	67,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
